/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.concurrent.atomic.AtomicLong;
import org.coodex.functional.Supplier;

public class Singleton<T> {
    private static final AtomicLong VERSION = new AtomicLong(Long.MIN_VALUE);
    private final Supplier<T> supplier;
    private long version = VERSION.get();
    private T instance = null;
    private volatile boolean loaded = false;

    private Singleton(Supplier<T> supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier MUST NOT be null.");
        }
        this.supplier = supplier;
    }

    public static void resetAll() {
        VERSION.incrementAndGet();
    }

    public static <T> Singleton<T> with(Supplier<T> supplier) {
        return new Singleton<T>(supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        if (!this.loaded || this.version != VERSION.get()) {
            Singleton singleton = this;
            synchronized (singleton) {
                if (!this.loaded || this.version != VERSION.get()) {
                    this.instance = this.supplier.get();
                    this.version = VERSION.get();
                    this.loaded = true;
                }
            }
        }
        return this.instance;
    }

    public void reset() {
        this.loaded = false;
    }
}

