/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.UUID;
import org.coodex.config.Config;
import org.coodex.functional.Supplier;
import org.coodex.util.Base58;
import org.coodex.util.Common;
import org.coodex.util.LazySelectableServiceLoader;
import org.coodex.util.SelectableService;
import org.coodex.util.SelectableServiceLoader;
import org.coodex.util.Singleton;
import org.coodex.util.java8.Base64;

public class UUIDHelper {
    private static final Singleton<String> CODE = Singleton.with(new Supplier<String>(){

        @Override
        public String get() {
            return Config.getValue("uuid.encoder", "base16", new String[0]);
        }
    });
    private static final SelectableServiceLoader<String, Encoder> ENCODER_SERVICE_LOADER = new LazySelectableServiceLoader<String, Encoder>((Encoder)new Base16Encoder()){};

    public static byte[] getUUIDBytes() {
        UUID uuid = UUID.randomUUID();
        long longOne = uuid.getMostSignificantBits();
        long longTwo = uuid.getLeastSignificantBits();
        return new byte[]{(byte)(longOne >>> 56), (byte)(longOne >>> 48), (byte)(longOne >>> 40), (byte)(longOne >>> 32), (byte)(longOne >>> 24), (byte)(longOne >>> 16), (byte)(longOne >>> 8), (byte)longOne, (byte)(longTwo >>> 56), (byte)(longTwo >>> 48), (byte)(longTwo >>> 40), (byte)(longTwo >>> 32), (byte)(longTwo >>> 24), (byte)(longTwo >>> 16), (byte)(longTwo >>> 8), (byte)longTwo};
    }

    public static String getUUIDString() {
        return ENCODER_SERVICE_LOADER.select(CODE.get()).encode(UUIDHelper.getUUIDBytes());
    }

    public static interface Encoder
    extends SelectableService<String> {
        public String encode(byte[] var1);
    }

    public static class Base16Encoder
    implements Encoder {
        @Override
        public String encode(byte[] bytes) {
            return Common.base16Encode(bytes);
        }

        @Override
        public boolean accept(String param) {
            return true;
        }
    }

    public static class Base58Encoder
    implements Encoder {
        @Override
        public String encode(byte[] bytes) {
            return Base58.encode(bytes);
        }

        @Override
        public boolean accept(String param) {
            return "base58".equalsIgnoreCase(param);
        }
    }

    public static class Base64UrlSafeEncoder
    implements Encoder {
        @Override
        public String encode(byte[] bytes) {
            return Base64.getUrlEncoder().encodeToString(bytes);
        }

        @Override
        public boolean accept(String param) {
            return "base64UrlSafe".equalsIgnoreCase(param);
        }
    }

    public static class Base64Encoder
    implements Encoder {
        @Override
        public String encode(byte[] bytes) {
            return Base64.getEncoder().encodeToString(bytes);
        }

        @Override
        public boolean accept(String param) {
            return "base64".equalsIgnoreCase(param);
        }
    }
}

