/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util.cv;

public class Color {
    private Color() {
    }

    public static int rgb(int r, int g, int b) {
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static HSVL rgb2hsvl(int rgb) {
        return new HSVL(rgb);
    }

    public static HSVL rgb2hsvl(int r, int g, int b) {
        return Color.rgb2hsvl((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public static HSVL rgb2hsvl(float r, float g, float b) {
        return new HSVL(r, g, b);
    }

    public static HSVL hsv(float h, float s, float v) {
        return new HSVL(h, s, v, 0.0f);
    }

    public static HSVL hsl(float h, float s, float l) {
        return new HSVL(h, s, 0.0f, l);
    }

    public static void main(String[] args) {
    }

    public static class HSVL {
        public final float h;
        public final float s;
        public final float v;
        public final float l;

        private HSVL(float h, float s, float v, float l) {
            this.h = h;
            this.s = s;
            this.v = v;
            this.l = l;
        }

        HSVL(float r, float g, float b) {
            float max = Math.max(Math.max(r, g), b);
            float min = Math.min(Math.min(r, g), b);
            float delta = max - min;
            this.l = (max + min) / 2.0f;
            this.h = delta == 0.0f ? 0.0f : (max == r ? (g - b) / delta * 60.0f + (g >= b ? 0.0f : 360.0f) : (max == g ? (b - r) / delta * 60.0f + 120.0f : (r - g) / delta * 60.0f + 240.0f));
            this.s = this.l == 0.0f || delta == 0.0f ? 0.0f : ((double)this.l <= 0.5 ? delta / (2.0f * this.l) : delta / (2.0f - 2.0f * this.l));
            this.v = max;
        }

        HSVL(int rgb) {
            this((float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f);
        }

        public String toString() {
            return "HSVL{h=" + this.h + ", s=" + this.s + ", v=" + this.v + ", l=" + this.l + '}';
        }
    }
}

