/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util.cv;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.imageio.ImageIO;
import org.coodex.functional.Function;

public class Img {
    public static boolean[][] map(String url, Function<Integer, Boolean> mapper) throws IOException {
        return Img.map(url, mapper, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static boolean[][] map(String url, Function<Integer, Boolean> mapper, int l, int t, int r, int b) throws IOException {
        try (InputStream inputStream = Files.newInputStream(new File(url).toPath(), new OpenOption[0]);){
            boolean[][] blArray = Img.map(inputStream, mapper, l, t, r, b);
            return blArray;
        }
    }

    public static boolean[][] map(InputStream inputStream, Function<Integer, Boolean> mapper, int l, int t, int r, int b) throws IOException {
        l = Math.max(0, l);
        t = Math.max(0, t);
        r = r <= l ? Integer.MAX_VALUE : r;
        b = b <= t ? Integer.MAX_VALUE : b;
        BufferedImage image = ImageIO.read(inputStream);
        r = Math.min(r, image.getWidth() - 1);
        b = Math.min(b, image.getHeight() - 1);
        int w = r - l + 1;
        int h = b - t + 1;
        boolean[][] bitmap = new boolean[h][w];
        for (int i = l; i <= r; ++i) {
            for (int j = t; j <= b; ++j) {
                bitmap[j - t][i - l] = mapper.apply(image.getRGB(i, j));
            }
        }
        return bitmap;
    }

    private static boolean[][] copyOf(boolean[][] bitmap) {
        int h = bitmap.length;
        int w = bitmap[0].length;
        boolean[][] v = new boolean[h][w];
        Img.arrayCopy(bitmap, v);
        return v;
    }

    private static void arrayCopy(boolean[][] src, boolean[][] dist) {
        int h = src.length;
        int w = src[0].length;
        for (int i = 0; i < h; ++i) {
            System.arraycopy(src[i], 0, dist[i], 0, w);
        }
    }

    private static void setTrue(boolean[][] array, int x, int y, int w, int h) {
        if (x < 0 || y < 0 || x >= w || y >= h) {
            return;
        }
        array[y][x] = true;
    }

    public static void grow(boolean[][] bitmap, int size, boolean cross) {
        boolean[][] kernel = new boolean[size * 2 + 1][size * 2 + 1];
        int len = size * 2 + 1;
        for (int i = 0; i <= size; ++i) {
            for (int j = 0; j <= size; ++j) {
                boolean cell;
                boolean bl = cell = !cross || i + j >= size;
                kernel[i][len - j - 1] = bl;
                kernel[len - i - 1][j] = bl;
                kernel[len - i - 1][len - j - 1] = bl;
                kernel[i][j] = bl;
            }
        }
        Img.grow(bitmap, kernel);
    }

    public static void grow(boolean[][] bitmap, boolean[][] kernel) {
        boolean[][] cache = Img.copyOf(bitmap);
        int h = bitmap.length;
        int w = bitmap[0].length;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                if (!bitmap[i][j]) continue;
                int offsetX = kernel.length / 2;
                for (int y = 0; y < kernel.length; ++y) {
                    int offsetY = kernel[y].length / 2;
                    for (int x = 0; x < kernel[y].length; ++x) {
                        if (!kernel[x][y]) continue;
                        Img.setTrue(cache, j - offsetX + x, i - offsetY + y, w, h);
                    }
                }
            }
        }
        Img.arrayCopy(cache, bitmap);
    }

    private static int countOf(boolean[][] bitmap) {
        int count = 0;
        boolean[][] blArray = bitmap;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            boolean[] array;
            for (boolean b : array = blArray[i]) {
                if (!b) continue;
                ++count;
            }
        }
        return count;
    }

    public static float coverageOf(boolean[][] bitmap) {
        int h = bitmap.length;
        int w = bitmap[0].length;
        return (float)Img.countOf(bitmap) * 1.0f / (float)(h * w);
    }
}

