/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.spring;

import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@Named
@Order(value=-2147483648)
public class SpringEnvironmentAware
implements SmartInstantiationAwareBeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(SpringEnvironmentAware.class);
    private static Environment springEnvironment;
    private static boolean traced;

    public SpringEnvironmentAware(Environment environment) {
        springEnvironment = environment;
        log.info("coodex-spring: spring environment injected. {}", environment == null ? null : environment.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Environment getSpringEnvironment() {
        if (springEnvironment != null || !log.isDebugEnabled()) return springEnvironment;
        if (traced) {
            return springEnvironment;
        }
        Class<SpringEnvironmentAware> clazz = SpringEnvironmentAware.class;
        synchronized (SpringEnvironmentAware.class) {
            StackTraceElement[] stackTraceElements;
            if (traced) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return springEnvironment;
            }
            traced = true;
            StringBuilder builder = new StringBuilder();
            for (StackTraceElement element : stackTraceElements = new Exception().getStackTrace()) {
                builder.append("\n\tat ").append(element);
            }
            log.debug("spring environment not injected yet.{}", (Object)builder);
            // ** MonitorExit[var0] (shouldn't be in output)
            return springEnvironment;
        }
    }

    static {
        traced = false;
    }
}

