/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.coodex.ssl.SSLContextFactory;
import org.coodex.ssl.X509TrustManagerImpl;
import org.coodex.util.Common;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertsSSLContextFactory
implements SSLContextFactory {
    private static final Logger log = LoggerFactory.getLogger(X509CertsSSLContextFactory.class);
    private static final String CERT_PATH = "certPath:".toLowerCase();
    private static final String CLASS_PATH = "cp:";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLContext getSSLContext(String param) throws Throwable {
        String certPath = Common.trim(param.substring(CERT_PATH.length()), ',', ' ', ':', ';');
        Set<String> allPath = Common.arrayToSet(Common.toArray(certPath, ";", new String[0]));
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        ArrayList<X509TrustManagerImpl> trustManagers = new ArrayList<X509TrustManagerImpl>();
        for (String path : allPath) {
            if (Common.isBlank(path)) continue;
            if (path.toLowerCase().startsWith(CLASS_PATH)) {
                String[] certs;
                for (String cert : certs = Common.toArray(path.substring(CLASS_PATH.length()), ",", new String[0])) {
                    try (InputStream inputStream = Common.getResource(cert, new ClassLoader[0]).openStream();){
                        trustManagers.add(new X509TrustManagerImpl(inputStream));
                    }
                }
                continue;
            }
            InputStream inputStream = this.getCertFromFile(path);
            if (inputStream == null) continue;
            try {
                trustManagers.add(new X509TrustManagerImpl(inputStream));
            }
            finally {
                inputStream.close();
            }
        }
        sslContext.init(null, trustManagers.toArray(new X509TrustManager[0]), null);
        return sslContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCertFromInputStream(KeyStore keyStore, InputStream inputStream, String alias) throws CertificateException, KeyStoreException, IOException {
        if (inputStream == null) {
            return;
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            keyStore.setCertificateEntry(alias, certificateFactory.generateCertificate(inputStream));
        }
        finally {
            inputStream.close();
        }
    }

    private InputStream getCertFromResource(String path) throws IOException {
        if (Common.isBlank(path)) {
            return null;
        }
        URL url = Common.getResource(Common.trim(path, ' ', '/'), new ClassLoader[0]);
        if (url == null) {
            log.warn("cert resource not found: classpath:{}", (Object)path);
            return null;
        }
        return url.openStream();
    }

    private InputStream getCertFromFile(String path) throws IOException {
        if (Common.isBlank(path)) {
            return null;
        }
        File file = new File(path);
        if (file.exists() && file.isFile()) {
            return new FileInputStream(file);
        }
        log.warn("cert file {} not exists.", (Object)path);
        return null;
    }

    @Override
    public boolean accept(String param) {
        return !Common.isBlank(param) && param.toLowerCase().startsWith(CERT_PATH);
    }
}

