/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.coodex.functional.Supplier;
import org.coodex.util.ReflectHelper;
import org.coodex.util.ServiceLoaderProvider;
import org.coodex.util.SingletonMap;

public abstract class AbstractServiceLoaderProvider
implements ServiceLoaderProvider {
    private final SingletonMap<Type, Map<String, Object>> cache = SingletonMap.builder().build();

    @Override
    public Map<String, Object> load(final Type serviceType) {
        return this.cache.get(serviceType, new Supplier<Map<String, Object>>(){

            @Override
            public Map<String, Object> get() {
                if (serviceType instanceof Class) {
                    return AbstractServiceLoaderProvider.this.loadByRowType((Class)serviceType);
                }
                if (serviceType instanceof ParameterizedType) {
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    for (Map.Entry<String, Object> entry : AbstractServiceLoaderProvider.this.loadByRowType((Class)((ParameterizedType)serviceType).getRawType()).entrySet()) {
                        String key = entry.getKey();
                        Object object = entry.getValue();
                        if (object == null || !ReflectHelper.isMatch(object.getClass(), serviceType)) continue;
                        result.put(key, object);
                    }
                    return result;
                }
                return new HashMap<String, Object>();
            }
        });
    }

    protected abstract Map<String, Object> loadByRowType(Class<?> var1);
}

