/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import org.coodex.functional.BiConsumer;
import org.coodex.functional.Supplier;
import org.coodex.util.AbstractServiceLoaderProvider;
import org.coodex.util.Common;
import org.coodex.util.ReflectHelper;
import org.coodex.util.SingletonMap;
import org.coodex.util.java8.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaUtilServiceLoaderProvider
extends AbstractServiceLoaderProvider {
    private static final Logger log = LoggerFactory.getLogger(JavaUtilServiceLoaderProvider.class);
    private static final boolean SINGLETON_ENABLED = Common.toBool(System.getProperty(ServiceLoader.class.getName() + ".singleton.enable"), true);
    private static final boolean CACHE_ENABLED = Common.toBool(System.getProperty(ServiceLoader.class.getName() + ".cache.enable"), true);
    private static final SingletonMap<Class<?>, Map<String, Object>> cache = SingletonMap.builder().build();

    @Override
    protected Map<String, Object> loadByRowType(final Class<?> rowType) {
        Map<String, Object> objectMap;
        Supplier<Map<String, Object>> supplier = new Supplier<Map<String, Object>>(){

            @Override
            public Map<String, Object> get() {
                Class<?>[] interfaces = rowType.getInterfaces();
                if (interfaces.length == 0) {
                    return JavaUtilServiceLoaderProvider.this.loadByInterface(rowType);
                }
                final HashMap<String, Object> objectMap = new HashMap<String, Object>();
                final HashSet classes = new HashSet();
                BiConsumer<String, Object> biConsumer = new BiConsumer<String, Object>(){

                    @Override
                    public void accept(String key, Object value) {
                        Class<?> instanceClass = value.getClass();
                        if (!classes.contains(instanceClass) && ReflectHelper.isMatch(instanceClass, rowType)) {
                            classes.add(instanceClass);
                            objectMap.put(key, value);
                        }
                    }
                };
                for (Class<?> interfaceClass : interfaces) {
                    if (SINGLETON_ENABLED) {
                        for (Map.Entry<String, Object> entry : JavaUtilServiceLoaderProvider.this.loadByRowType(interfaceClass).entrySet()) {
                            biConsumer.accept(entry.getKey(), entry.getValue());
                        }
                        continue;
                    }
                    objectMap.putAll(JavaUtilServiceLoaderProvider.this.loadByRowType(interfaceClass));
                }
                if (rowType.isInterface()) {
                    for (Map.Entry entry : JavaUtilServiceLoaderProvider.this.loadByInterface(rowType).entrySet()) {
                        biConsumer.accept((String)entry.getKey(), entry.getValue());
                    }
                }
                return objectMap;
            }
        };
        Map<String, Object> map = objectMap = CACHE_ENABLED ? cache.get(rowType, supplier) : (Map<String, Object>)supplier.get();
        if (Common.isDebug() && log.isDebugEnabled()) {
            if (!objectMap.isEmpty()) {
                StringJoiner joiner = new StringJoiner("\n\t");
                for (Map.Entry<String, Object> entry : objectMap.entrySet()) {
                    joiner.add(entry.getKey() + ": " + entry.getValue().toString());
                }
                log.debug("{} JUS instances loaded for: {} instances: \n\t{}", new Object[]{objectMap.size(), rowType, joiner.toString()});
            } else {
                log.debug("no JUS instance loaded for {}", rowType);
            }
        }
        return objectMap;
    }

    private Map<String, Object> loadByInterface(Class<?> interfaceClass) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object service : ServiceLoader.load(interfaceClass)) {
            map.put(service.getClass().getName(), service);
        }
        return map;
    }
}

