/*
 * Copyright (c) 2020 coodex.org (jujus.shen@126.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.coodex.id;

import org.coodex.functional.Supplier;
import org.coodex.util.LazyServiceLoader;
import org.coodex.util.ServiceLoader;

public class IDGenerator {

    private static final ServiceLoader<IDGeneratorService> ID_GENERATOR_SERVICE_SERVICE_LOADER
            = new LazyServiceLoader<IDGeneratorService>(new Supplier<IDGeneratorService>() {
        @Override
        public IDGeneratorService get() {
            return new SnowflakeIdGeneratorService();
        }
    }) {
    };

    public static String newId() {
        return ID_GENERATOR_SERVICE_SERVICE_LOADER.get().newId();
    }
}
