/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.coodex.util.Common;

public class DigestHelper {
    private static final String DEFAULT_ENCODING = "UTF-8";

    public static String digest(byte[] buf, String algorithm) {
        return Common.base16Encode(DigestHelper.digestBuff(buf, algorithm));
    }

    public static byte[] digestBuff(byte[] buf, String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm).digest(buf);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] digestBuff(InputStream is, String algorithm) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] buf = new byte[1024];
            int r = 0;
            while ((r = is.read(buf)) > 0) {
                digest.update(buf, 0, r);
            }
            return digest.digest();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String sha1(byte[] content) {
        return DigestHelper.digest(content, "sha1");
    }

    public static String sha256(byte[] content) {
        return DigestHelper.digest(content, "sha-256");
    }

    public static String md5(byte[] content) {
        return DigestHelper.digest(content, "md5");
    }

    public static byte[] hmac(byte[] content, byte[] key, String algorithm) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec secretKey = new SecretKeySpec(key, "RAW");
        Mac mac = Mac.getInstance(algorithm);
        mac.init(secretKey);
        return mac.doFinal(content);
    }

    public static byte[] hmac(byte[] content, byte[] key) throws NoSuchAlgorithmException, InvalidKeyException {
        return DigestHelper.hmac(content, key, "HmacSHA1");
    }

    public static String hmac(String content, String key, String algorithm, String encoding) throws UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException {
        if (content == null) {
            content = "";
        }
        if (key == null) {
            throw new NullPointerException("hmac key is NULL.");
        }
        return Common.base16Encode(DigestHelper.hmac(content.getBytes(encoding), key.getBytes(encoding), algorithm));
    }

    public static String hmac(String content, String key, String algorithm) throws UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException {
        return DigestHelper.hmac(content, key, algorithm, DEFAULT_ENCODING);
    }

    public static String hmac(String content, String key) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException {
        return DigestHelper.hmac(content, key, "HmacSHA1");
    }
}

