/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.coodex.util.GenericTypeHelper;
import org.coodex.util.JSONSerializer;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONSerializerTestCase {
    private static final Logger log = LoggerFactory.getLogger(JSONSerializerTestCase.class);

    public static void test(JSONSerializer jsonSerializer) {
        String nullStr = jsonSerializer.toJson(null);
        Assertions.assertEquals((Object)nullStr, (Object)"null");
        Assertions.assertNull(jsonSerializer.parse(null, (Type)((Object)Object.class)));
        Assertions.assertNull(jsonSerializer.parse("", (Type)((Object)Object.class)));
        Object o = jsonSerializer.parse(nullStr, (Type)((Object)Object.class));
        Assertions.assertNull(o);
        String strNullStr = jsonSerializer.toJson("null");
        Assertions.assertEquals((Object)strNullStr, (Object)"\"null\"");
        Assertions.assertEquals((Object)"null", jsonSerializer.parse(strNullStr, (Type)((Object)String.class)));
        Assertions.assertNull(jsonSerializer.parse(null, (Type)((Object)Object.class)));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("number", Float.valueOf(1.0f));
        map.put("numberArray", new int[]{1, 2, 3});
        map.put("string", "str");
        map.put("stringArray", new String[]{"str1", "str2"});
        map.put("null", null);
        map.put("nullArray", new Object[]{null, null});
        ObjTest obj = new ObjTest();
        map.put("object", obj);
        map.put("objectArray", new Object[]{obj, obj});
        map.put("enumArray", new TestEnum[]{TestEnum.T1, TestEnum.T2});
        String mapJson = jsonSerializer.toJson(map);
        log.info("serialized: {}", (Object)mapJson);
        Map stringObjectMap = (Map)jsonSerializer.parse(mapJson, new GenericTypeHelper.GenericType<Map<String, Object>>(){}.getType());
        JSONSerializerTestCase.case2(mapJson, jsonSerializer);
        JSONSerializerTestCase.case2("[1,2,3]", jsonSerializer);
        JSONSerializerTestCase.case2("1", jsonSerializer);
        JSONSerializerTestCase.case2("null", jsonSerializer);
        JSONSerializerTestCase.case2(jsonSerializer.toJson(obj), jsonSerializer);
    }

    private static void case2(String str, JSONSerializer jsonSerializer) {
        Object o = jsonSerializer.parse(str, (Type)((Object)Object.class));
        log.info(o == null ? "null" : o.getClass() + ":" + o);
        Assertions.assertEquals((Object)str, (Object)jsonSerializer.toJson(o));
    }

    public static class ObjTest {
        public int a = 1;
        public String b = "null";
        public String c = "{}";

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjTest objTest = (ObjTest)o;
            return this.a == objTest.a && Objects.equals(this.b, objTest.b) && Objects.equals(this.c, objTest.c);
        }

        public int hashCode() {
            return Objects.hash(this.a, this.b, this.c);
        }
    }

    public static enum TestEnum {
        T1,
        T2;

    }
}

