/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import org.coodex.annotatoin.Remark;
import org.coodex.functional.BiConsumer;
import org.coodex.functional.Function;
import org.coodex.functional.Supplier;
import org.coodex.util.AbstractServiceLoaderProvider;
import org.coodex.util.Common;
import org.coodex.util.ReflectHelper;
import org.coodex.util.SingletonMap;
import org.coodex.util.java8.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaUtilServiceLoaderProvider
extends AbstractServiceLoaderProvider {
    private static final Logger log = LoggerFactory.getLogger(JavaUtilServiceLoaderProvider.class);
    private static ClassLoader defaultClassLoader;
    private static final boolean SINGLETON_ENABLED = true;
    private static final boolean CACHE_ENABLED = true;
    private static final SingletonMap<Class<?>, Map<String, Object>> cache;

    @Remark(value="\u5bf9\u5916\u66b4\u9732\u8bbe\u7f6e\u9ed8\u8ba4\u7684classLoader\uff0c\u4e3b\u8981\u4e3a\u4e86\u9002\u914dAndroid\u4f4e\u7248\u672c\u6216\u8005\u4e0d\u5b8c\u5584\u7684\u9a71\u52a8\u9020\u6210\u65e0\u6cd5\u4f7f\u7528SPI\u65f6\u65e0\u6cd5\u627e\u5230\u670d\u52a1\u5b9e\u4f8b\u7684\u60c5\u51b5")
    public static void register(ClassLoader defaultClassLoader) {
        JavaUtilServiceLoaderProvider.defaultClassLoader = defaultClassLoader;
    }

    @Override
    protected Map<String, Object> loadByRowType(final Class<?> rowType) {
        Supplier<Map<String, Object>> supplier = new Supplier<Map<String, Object>>(){

            @Override
            public Map<String, Object> get() {
                Class<?>[] interfaces = rowType.getInterfaces();
                if (interfaces.length == 0) {
                    return JavaUtilServiceLoaderProvider.this.loadByInterface(rowType);
                }
                final HashMap<String, Object> objectMap = new HashMap<String, Object>();
                final HashSet classes = new HashSet();
                BiConsumer<String, Object> biConsumer = new BiConsumer<String, Object>(){

                    @Override
                    public void accept(String key, Object value) {
                        Class<?> instanceClass = value.getClass();
                        if (!classes.contains(instanceClass) && ReflectHelper.isMatch(instanceClass, rowType)) {
                            classes.add(instanceClass);
                            objectMap.put(key, value);
                        }
                    }
                };
                for (Class<?> interfaceClass : interfaces) {
                    for (Map.Entry<String, Object> entry : JavaUtilServiceLoaderProvider.this.loadByRowType(interfaceClass).entrySet()) {
                        biConsumer.accept(entry.getKey(), entry.getValue());
                    }
                }
                if (rowType.isInterface()) {
                    for (Map.Entry entry : JavaUtilServiceLoaderProvider.this.loadByInterface(rowType).entrySet()) {
                        biConsumer.accept((String)entry.getKey(), entry.getValue());
                    }
                }
                return objectMap;
            }
        };
        Map<String, Object> objectMap = cache.get(rowType, supplier);
        if (Common.isDebug() && log.isDebugEnabled()) {
            if (!objectMap.isEmpty()) {
                StringJoiner joiner = new StringJoiner("\n\t");
                for (Map.Entry<String, Object> entry : objectMap.entrySet()) {
                    joiner.add(entry.getKey() + ": " + entry.getValue().toString());
                }
                log.debug("{} JUS instances loaded for: {} instances: \n\t{}", new Object[]{objectMap.size(), rowType, joiner.toString()});
            } else {
                log.debug("no JUS instance loaded for {}", rowType);
            }
        }
        return objectMap;
    }

    public static ClassLoader defaultLoader(Class<?> service) {
        ClassLoader cl = defaultClassLoader;
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if (cl == null) {
            cl = service.getClassLoader();
        }
        if (cl == null) {
            cl = JavaUtilServiceLoaderProvider.class.getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    private Map<String, Object> loadByInterface(Class<?> interfaceClass) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object service : ServiceLoader.load(interfaceClass, JavaUtilServiceLoaderProvider.defaultLoader(interfaceClass))) {
            map.put(service.getClass().getName(), service);
        }
        log.info("[SPI-java.util]load {} Service instances: {}, {}", new Object[]{map.size(), interfaceClass, JavaUtilServiceLoaderProvider.defaultLoader(interfaceClass)});
        return map;
    }

    static {
        cache = SingletonMap.builder().function(new Function<Class<?>, Map<String, Object>>(){

            @Override
            public Map<String, Object> apply(Class<?> aClass) {
                return Collections.emptyMap();
            }
        }).build();
    }
}

