/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.coodex.functional.Supplier;
import org.coodex.util.Common;
import org.coodex.util.GenericTypeHelper;
import org.coodex.util.JavaUtilServiceLoaderProvider;
import org.coodex.util.SPI;
import org.coodex.util.ServiceLoader;
import org.coodex.util.ServiceLoaderHelper;
import org.coodex.util.ServiceLoaderProvider;
import org.coodex.util.Singleton;
import org.coodex.util.java8.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LazyServiceLoader<T>
implements ServiceLoader<T> {
    private final Singleton<Iterable<ServiceLoaderProvider>> serviceLoaderProviderInstances = Singleton.with(new Supplier<Iterable<ServiceLoaderProvider>>(){

        @Override
        public Iterable<ServiceLoaderProvider> get() {
            return java.util.ServiceLoader.load(ServiceLoaderProvider.class, JavaUtilServiceLoaderProvider.defaultLoader(ServiceLoader.class));
        }
    });
    private static final Logger log = LoggerFactory.getLogger(LazyServiceLoader.class);
    private final Singleton<Instances> instances = Singleton.with(new Supplier<Instances>(){

        @Override
        public Instances get() {
            Instances instances = new Instances();
            instances.instancesMap = new HashMap<String, Object>();
            for (ServiceLoaderProvider provider : (Iterable)LazyServiceLoader.this.serviceLoaderProviderInstances.get()) {
                instances.instancesMap.putAll(provider.load(LazyServiceLoader.this.getServiceType()));
            }
            if (Common.isDebug() && log.isDebugEnabled()) {
                if (instances.instancesMap.isEmpty()) {
                    log.debug("no ServiceProvider found for [{}], using default provider.", (Object)LazyServiceLoader.this.getServiceType());
                } else {
                    StringJoiner joiner = new StringJoiner("\n\t");
                    for (Map.Entry<String, Object> entry : instances.instancesMap.entrySet()) {
                        String k = entry.getKey();
                        Object v = entry.getValue();
                        joiner.add(k + "(" + SPI.getServiceOrder(v) + "): " + v.toString());
                    }
                    log.debug("{} SPI instances loaded for: {} instances: \n\t{}", new Object[]{instances.instancesMap.size(), LazyServiceLoader.this.getServiceType(), joiner.toString()});
                }
            }
            instances.unmodifiedMap = Collections.unmodifiableMap(instances.instancesMap);
            return instances;
        }
    });
    private final Singleton<Map<String, T>> allInstanceSingleton = Singleton.with(new Supplier<Map<String, T>>(){

        @Override
        public Map<String, T> get() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : ((Instances)((LazyServiceLoader)LazyServiceLoader.this).instances.get()).unmodifiedMap.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
            return map;
        }
    });
    private Supplier<T> defaultProviderSupplier;
    private final Singleton<T> defaultProviderSingleton = Singleton.with(new Supplier<T>(){

        @Override
        public T get() {
            if (LazyServiceLoader.this.defaultProviderSupplier == null) {
                LazyServiceLoader.this.defaultProviderSupplier = new Supplier<T>(){

                    @Override
                    public T get() {
                        return LazyServiceLoader.this.getDefaultInstance();
                    }
                };
            }
            return LazyServiceLoader.this.defaultProviderSupplier.get();
        }
    });

    public LazyServiceLoader() {
        this(null);
    }

    public LazyServiceLoader(final T defaultProvider) {
        this(defaultProvider == null ? null : new Supplier<T>(){

            @Override
            public T get() {
                return defaultProvider;
            }
        });
    }

    public LazyServiceLoader(Supplier<T> defaultProviderSupplier) {
        this.defaultProviderSupplier = defaultProviderSupplier;
    }

    protected Object getGenericTypeSearchContextObject() {
        return this;
    }

    protected Type getServiceType() {
        return GenericTypeHelper.solveFromInstance(ServiceLoader.class.getTypeParameters()[0], this.getGenericTypeSearchContextObject());
    }

    @Override
    public final T getDefault() {
        return this.defaultProviderSingleton.get();
    }

    protected T getDefaultInstance() {
        throw new RuntimeException("no provider found for: " + this.getServiceType().toString());
    }

    @Override
    public Map<String, T> getAll() {
        return this.allInstanceSingleton.get();
    }

    @Override
    public T get(Class<? extends T> providerClass) {
        HashMap<String, Object> copy = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.instances.get().instancesMap.entrySet()) {
            if (entry.getValue() == null || !providerClass.isAssignableFrom(entry.getValue().getClass())) continue;
            copy.put(entry.getKey(), entry.getValue());
        }
        switch (copy.size()) {
            case 0: {
                T defaultProviderValue = this.getDefault();
                if (defaultProviderValue != null && providerClass.isAssignableFrom(defaultProviderValue.getClass())) {
                    return defaultProviderValue;
                }
                return null;
            }
            case 1: {
                return Common.cast(copy.values().iterator().next());
            }
        }
        return this.conflict(providerClass, copy);
    }

    protected T conflict(Class<? extends T> providerClass, Map<String, Object> map) {
        T t = this.get(providerClass.getName());
        if (t != null) {
            return t;
        }
        StringBuilder buffer = new StringBuilder(this.getServiceType().toString());
        buffer.append("[providerClass: ").append(providerClass.getName()).append("]");
        buffer.append(" has ").append(map.size()).append(" services:[");
        for (Object service : map.values()) {
            buffer.append("\n\t").append(service.getClass().getName());
        }
        buffer.append("]");
        throw new RuntimeException(buffer.toString());
    }

    @Override
    public T get(String name) {
        Object instance = Common.cast(this.instances.get().instancesMap.get(name));
        return instance == null ? this.getDefault() : instance;
    }

    protected T conflict() {
        StringBuilder buffer = new StringBuilder(this.getServiceType().toString());
        buffer.append(" has ").append(this.instances.get().instancesMap.size()).append(" services:[");
        for (Object service : this.instances.get().instancesMap.values()) {
            buffer.append("\n\t").append(service.getClass().getName());
        }
        buffer.append("]");
        throw new RuntimeException(buffer.toString());
    }

    @Override
    public T get() {
        if (this.instances.get().instancesMap.isEmpty()) {
            return this.defaultProviderSingleton.get();
        }
        if (this.instances.get().instancesMap.size() == 1) {
            return Common.cast(this.instances.get().instancesMap.values().toArray()[0]);
        }
        return this.conflict();
    }

    @Override
    public List<T> sorted() {
        return ServiceLoaderHelper.sort(this);
    }

    @Override
    public List<T> sorted(Comparator<? super T> comparator) {
        return ServiceLoaderHelper.sort(this, comparator);
    }

    private static class Instances {
        Map<String, Object> instancesMap = null;
        Map<String, Object> unmodifiedMap = null;

        private Instances() {
        }
    }
}

