/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.coodex.util.GenericTypeHelper;
import org.coodex.util.PojoProperty;

public class PojoInfo {
    private final Type type;
    private final Class<?> rowType;
    private final Map<String, PojoProperty> properties = new HashMap<String, PojoProperty>();

    public PojoInfo(Type type) {
        this.type = type;
        this.rowType = GenericTypeHelper.typeToClass(this.type);
        if (this.rowType == null) {
            throw new RuntimeException(type + " is NOT POJO.");
        }
        this.buildMethodProperties();
        this.buildFieldProperties();
    }

    public Type getType() {
        return this.type;
    }

    public Class<?> getRowType() {
        return this.rowType;
    }

    private void buildFieldProperties() {
        for (Field field : this.rowType.getFields()) {
            int mod = field.getModifiers();
            if (!Modifier.isPublic(mod) || Modifier.isStatic(mod) || this.properties.containsKey(field.getName())) continue;
            this.properties.put(field.getName(), this.buildProperty(null, field, Modifier.isFinal(field.getModifiers()), GenericTypeHelper.toReference(field.getGenericType(), this.type), field.getName()));
        }
    }

    private void buildMethodProperties() {
        for (Method method : this.rowType.getMethods()) {
            PojoProperty property;
            if (Void.TYPE.equals(method.getReturnType()) || method.getParameterTypes().length > 0 || method.getName().equals("getClass") || Class.class.equals(method.getDeclaringClass()) || Object.class.equals(method.getDeclaringClass()) || (property = this.testProperty(method, this.testBoolProperty(method))) == null) continue;
            this.properties.put(property.getName(), property);
        }
    }

    private PojoProperty testProperty(Method method, PojoProperty property) {
        String methodName;
        if (property == null && (methodName = method.getName()).length() > 3 && methodName.startsWith("get")) {
            String beanName = this.lowerFirstChar(methodName.substring(3));
            return this.buildProperty(method, this.testField(beanName), this.isReadOnly(method), GenericTypeHelper.toReference(method.getGenericReturnType(), this.type), beanName);
        }
        return property;
    }

    protected PojoProperty buildProperty(Method method, Field field, boolean readonly, Type type, String name) {
        return new PojoProperty(method, field, readonly, type, name);
    }

    private PojoProperty testBoolProperty(Method method) {
        String methodName = method.getName();
        if ((Boolean.TYPE.equals(method.getReturnType()) || Boolean.class.equals(method.getReturnType())) && methodName.length() > 2 && methodName.startsWith("is")) {
            String beanName = this.lowerFirstChar(methodName.substring(2));
            return this.buildProperty(method, this.testField(beanName), this.isReadOnly(method), method.getReturnType(), beanName);
        }
        return null;
    }

    private boolean isReadOnly(Method method) {
        try {
            this.rowType.getMethod("set" + method.getName().substring(method.getName().startsWith("is") ? 2 : 3), method.getReturnType());
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return true;
        }
    }

    private Field testField(String beanName) {
        return this.getField(beanName, this.rowType);
    }

    private Field getField(String fieldName, Class<?> c) {
        if (c == null) {
            return null;
        }
        try {
            return c.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return this.getField(fieldName, c.getSuperclass());
        }
    }

    private String lowerFirstChar(String s) {
        char ch = s.charAt(0);
        if (ch >= 'A' && ch <= 'Z') {
            char[] buf = s.toCharArray();
            buf[0] = (char)(ch - 65 + 97);
            return new String(buf);
        }
        return s;
    }

    public PojoProperty getProperty(String name) {
        return this.properties.get(name);
    }

    public Collection<PojoProperty> getProperties() {
        return this.properties.values();
    }
}

