/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.parser;

import java.text.DecimalFormat;
import net.sf.marineapi.ais.message.AISMessage09;
import net.sf.marineapi.ais.parser.AISMessageParser;
import net.sf.marineapi.ais.util.AISRuleViolation;
import net.sf.marineapi.ais.util.Angle12;
import net.sf.marineapi.ais.util.Latitude27;
import net.sf.marineapi.ais.util.Longitude28;
import net.sf.marineapi.ais.util.Sixbit;
import net.sf.marineapi.ais.util.SpeedOverGround;
import net.sf.marineapi.ais.util.TimeStamp;

class AISMessage09Parser
extends AISMessageParser
implements AISMessage09 {
    private static final String SEPARATOR = "\n\t";
    private static final int ALTITUDE = 0;
    private static final int SPEEDOVERGROUND = 1;
    private static final int POSITIONACCURACY = 2;
    private static final int LONGITUDE = 3;
    private static final int LATITUDE = 4;
    private static final int COURSEOVERGROUND = 5;
    private static final int TIMESTAMP = 6;
    private static final int REGIONAL = 7;
    private static final int DTE = 8;
    private static final int SPARE = 9;
    private static final int ASSIGNEDMODEFLAG = 10;
    private static final int RAIMFLAG = 11;
    private static final int RADIOSTATUS = 12;
    private static final int[] FROM = new int[]{38, 50, 60, 61, 89, 116, 128, 134, 142, 43, 146, 147, 149};
    private static final int[] TO = new int[]{50, 60, 61, 89, 116, 128, 134, 142, 43, 146, 147, 149, 167};
    private int fAltitude;
    private int fSOG;
    private boolean fPositionAccuracy;
    private int fLongitude;
    private int fLatitude;
    private int fCOG;
    private int fTimeStamp;
    private int fRegional;
    private boolean fDTE;
    private boolean fAssignedModeFlag;
    private boolean fRAIMFlag;
    private int fRadioStatus;

    public AISMessage09Parser(Sixbit content) {
        super(content, 168);
        this.fAltitude = content.getInt(FROM[0], TO[0]);
        this.fSOG = content.getInt(FROM[1], TO[1]);
        this.fPositionAccuracy = content.getBoolean(TO[2]);
        this.fLongitude = content.getAs28BitInt(FROM[3], TO[3]);
        if (!Longitude28.isCorrect(this.fLongitude)) {
            this.addViolation(new AISRuleViolation("LongitudeInDegrees", this.fLongitude, "[-108000000,108000000] + {108600000}"));
        }
        this.fLatitude = content.getAs27BitInt(FROM[4], TO[4]);
        if (!Latitude27.isCorrect(this.fLatitude)) {
            this.addViolation(new AISRuleViolation("LatitudeInDegrees", this.fLatitude, "[-54000000,54000000] + {54600000}"));
        }
        this.fCOG = content.getInt(FROM[5], TO[5]);
        if (!Angle12.isCorrect(this.fCOG)) {
            this.addViolation(new AISRuleViolation("CourseOverGround", this.fCOG, "[0,3599] + {3600}"));
        }
        this.fTimeStamp = content.getInt(FROM[6], TO[6]);
        this.fRegional = content.getInt(FROM[7], TO[7]);
        this.fDTE = content.getBoolean(TO[8]);
        this.fAssignedModeFlag = content.getBoolean(TO[10]);
        this.fRAIMFlag = content.getBoolean(TO[11]);
        this.fRadioStatus = content.getInt(FROM[12], TO[12]);
    }

    @Override
    public int getAltitude() {
        return this.fAltitude;
    }

    @Override
    public int getSpeedOverGround() {
        return this.fSOG;
    }

    public String getSOGString() {
        String msg = this.fSOG == 1023 ? "no SOG" : (this.fSOG == 1022 ? ">=1022" : new DecimalFormat("##0.0").format((double)this.fSOG / 10.0));
        return msg;
    }

    @Override
    public boolean isAccurate() {
        return this.fPositionAccuracy;
    }

    @Override
    public double getLongitudeInDegrees() {
        return Longitude28.toDegrees(this.fLongitude);
    }

    @Override
    public double getLatitudeInDegrees() {
        return Latitude27.toDegrees(this.fLatitude);
    }

    @Override
    public double getCourseOverGround() {
        return Angle12.toDegrees(this.fCOG);
    }

    @Override
    public int getTimeStamp() {
        return this.fTimeStamp;
    }

    public int getRegional() {
        return this.fRegional;
    }

    @Override
    public boolean getDTEFlag() {
        return this.fDTE;
    }

    @Override
    public boolean getAssignedModeFlag() {
        return this.fAssignedModeFlag;
    }

    @Override
    public boolean getRAIMFlag() {
        return this.fRAIMFlag;
    }

    @Override
    public int getRadioStatus() {
        return this.fRadioStatus;
    }

    @Override
    public boolean hasLongitude() {
        return Longitude28.isAvailable(this.fLongitude);
    }

    @Override
    public boolean hasLatitude() {
        return Latitude27.isAvailable(this.fLatitude);
    }

    public String toString() {
        String result = "\tAlt:      " + this.fAltitude;
        result = result + "\n\tSOG:     " + SpeedOverGround.toString(this.fSOG);
        result = result + "\n\tPos acc: " + (this.fPositionAccuracy ? "high" : "low") + " accuracy";
        result = result + "\n\tLon:     " + Longitude28.toString(this.fLongitude);
        result = result + "\n\tLat:     " + Latitude27.toString(this.fLatitude);
        result = result + "\n\tCOG:     " + Angle12.toString(this.fCOG);
        result = result + "\n\tTime:    " + TimeStamp.toString(this.fTimeStamp);
        result = result + "\n\tRegional:     " + this.getRegional();
        result = result + "\n\tDTE: " + (this.fDTE ? "yes" : "no");
        result = result + "\n\tAssigned Mode Flag: " + (this.fAssignedModeFlag ? "yes" : "no");
        result = result + "\n\tRAIM Flag: " + (this.fRAIMFlag ? "yes" : "no");
        result = result + "\n\tRadioStatus:     " + this.getRadioStatus();
        return result;
    }
}

