/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.util;

import net.sf.marineapi.ais.util.BitVector;

public class Sixbit {
    public static final int BITS_PER_CHAR = 6;
    private final String fPayload;
    private BitVector fBitVector;
    private final int fFillBits;

    public Sixbit(String payload, int fillBits) {
        if (payload == null || payload.isEmpty()) {
            throw new IllegalArgumentException("Message payload cannot be null or empty");
        }
        if (fillBits < 0) {
            throw new IllegalArgumentException("Fill bits cannot be negative");
        }
        this.fPayload = payload;
        if (!this.isValidString(this.fPayload)) {
            throw new IllegalArgumentException("Invalid payload characters");
        }
        this.fBitVector = new BitVector(this.fPayload.length() * 6);
        for (int i = 0; i < this.fPayload.length(); ++i) {
            char c = this.fPayload.charAt(i);
            int b = this.transportToBinary(c);
            this.convert(b, i * 6, 6);
        }
        this.fFillBits = fillBits;
    }

    private void convert(int value, int from, int length) {
        int index = from + 6;
        while ((long)value != 0L && length > 0) {
            if ((long)value % 2L != 0L) {
                this.fBitVector.set(index);
            }
            --index;
            value >>>= 1;
            --length;
        }
    }

    public BitVector get(int from, int to) {
        return this.fBitVector.get(from, to);
    }

    private boolean isValidCharacter(char ascii) {
        return ascii >= '0' && ascii <= 'w' && (ascii <= 'W' || ascii >= '`');
    }

    private boolean isValidString(String bits) {
        boolean valid = true;
        for (int i = 0; i < bits.length(); ++i) {
            if (this.isValidCharacter(bits.charAt(i))) continue;
            valid = false;
            break;
        }
        return valid;
    }

    public int length() {
        return this.fPayload.length() * 6 - this.fFillBits;
    }

    private int transportToBinary(char ascii) {
        if (!this.isValidCharacter(ascii)) {
            throw new IllegalArgumentException("Invalid transport character: " + ascii);
        }
        int retval = ascii < '`' ? ascii - 48 : ascii - 56;
        return retval;
    }

    private char binaryToContent(int value) {
        if (value < 32) {
            return (char)(value + 64);
        }
        return (char)value;
    }

    public boolean getBoolean(int index) {
        return this.fBitVector.getBoolean(index);
    }

    public int getInt(int from, int to) {
        return this.fBitVector.getUInt(from, to);
    }

    public int getAs8BitInt(int from, int to) {
        return this.fBitVector.getAs8BitInt(from, to);
    }

    public int getAs17BitInt(int from, int to) {
        return this.fBitVector.getAs17BitInt(from, to);
    }

    public int getAs18BitInt(int from, int to) {
        return this.fBitVector.getAs18BitInt(from, to);
    }

    public int getAs27BitInt(int from, int to) {
        return this.fBitVector.getAs27BitInt(from, to);
    }

    public int getAs28BitInt(int from, int to) {
        return this.fBitVector.getAs28BitInt(from, to);
    }

    public String getString(int fromIndex, int toIndex) {
        StringBuilder sb = new StringBuilder();
        for (int i = fromIndex; i < toIndex; i += 6) {
            int value = this.getInt(i, i + 6);
            sb.append(this.binaryToContent(value));
        }
        return this.stripAtSigns(sb.toString());
    }

    private String stripAtSigns(String orig) {
        int end = orig.length() - 1;
        for (int i = orig.length() - 1; i >= 0; --i) {
            if (orig.charAt(i) == '@') continue;
            end = i;
            break;
        }
        return orig.substring(0, end + 1);
    }

    public String getPayload() {
        return this.fPayload;
    }
}

