/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.util;

import java.text.DecimalFormat;

public class SpeedOverGround {
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 1022;
    private static final int DEFAULT_VALUE = 1023;

    public static boolean isAvailable(int value) {
        return value >= 0 && value <= 1022;
    }

    public static boolean isCorrect(int value) {
        return SpeedOverGround.isAvailable(value) || value == 1023;
    }

    public static double toKnots(int value) {
        return (double)value / 10.0;
    }

    public static String toString(int value) {
        if (!SpeedOverGround.isAvailable(value)) {
            return "no SOG";
        }
        if (value == 1022) {
            return ">=102.2";
        }
        return new DecimalFormat("##0.0").format(SpeedOverGround.toKnots(value));
    }
}

