/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.example;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.sf.marineapi.nmea.io.SentenceReader;
import net.sf.marineapi.provider.HeadingProvider;
import net.sf.marineapi.provider.event.HeadingEvent;
import net.sf.marineapi.provider.event.HeadingListener;

public class HeadingProviderExample
implements HeadingListener {
    private SentenceReader reader;
    private HeadingProvider provider;

    public HeadingProviderExample(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        this.reader = new SentenceReader(stream);
        this.provider = new HeadingProvider(this.reader);
        this.provider.addListener(this);
        this.reader.start();
    }

    @Override
    public void providerUpdate(HeadingEvent evt) {
        System.out.println(evt.toString());
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            String msg = "Example usage:\njava HeadingProviderExample nmea.log";
            System.out.println(msg);
            System.exit(0);
        }
        try {
            new HeadingProviderExample(new File(args[0]));
            System.out.println("Running, press CTRL-C to stop..");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

