/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.io;

import java.io.InputStream;
import java.net.DatagramSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.marineapi.nmea.event.SentenceEvent;
import net.sf.marineapi.nmea.event.SentenceListener;
import net.sf.marineapi.nmea.io.AbstractDataReader;
import net.sf.marineapi.nmea.io.DataListener;
import net.sf.marineapi.nmea.io.DefaultDataReader;
import net.sf.marineapi.nmea.io.ExceptionListener;
import net.sf.marineapi.nmea.io.UDPDataReader;
import net.sf.marineapi.nmea.sentence.Sentence;
import net.sf.marineapi.nmea.sentence.SentenceId;

public class SentenceReader {
    public static final int DEFAULT_TIMEOUT = 5000;
    private static final String DISPATCH_ALL = "DISPATCH_ALL";
    private static final Logger LOGGER = Logger.getLogger(SentenceReader.class.getName());
    private static final String LOG_MSG = "Exception caught from SentenceListener";
    private Thread thread;
    private AbstractDataReader reader;
    private ConcurrentMap<String, List<SentenceListener>> listeners = new ConcurrentHashMap<String, List<SentenceListener>>();
    private volatile int pauseTimeout = 5000;
    private DataListener dataListener;
    private ExceptionListener exceptionListener;

    public SentenceReader(DatagramSocket source) {
        this.reader = new UDPDataReader(source, this);
    }

    public SentenceReader(InputStream source) {
        this.reader = new DefaultDataReader(source, this);
    }

    public SentenceReader(AbstractDataReader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("Data reader cannot be null");
        }
        reader.setParent(this);
        this.reader = reader;
    }

    public void addSentenceListener(SentenceListener listener) {
        this.registerListener(listener, DISPATCH_ALL);
    }

    public void addSentenceListener(SentenceListener sl, SentenceId type) {
        this.registerListener(sl, type.toString());
    }

    public void addSentenceListener(SentenceListener sl, String type) {
        this.registerListener(sl, type);
    }

    void fireDataEvent(String data) {
        try {
            if (this.dataListener != null) {
                this.dataListener.dataRead(data);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception thrown by DataListener", e);
        }
    }

    void fireReadingPaused() {
        for (SentenceListener listener : this.getSentenceListeners()) {
            try {
                listener.readingPaused();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, LOG_MSG, e);
            }
        }
    }

    void fireReadingStarted() {
        for (SentenceListener listener : this.getSentenceListeners()) {
            try {
                listener.readingStarted();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, LOG_MSG, e);
            }
        }
    }

    void fireReadingStopped() {
        for (SentenceListener listener : this.getSentenceListeners()) {
            try {
                listener.readingStopped();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, LOG_MSG, e);
            }
        }
    }

    void fireSentenceEvent(Sentence sentence) {
        String type = sentence.getSentenceId();
        HashSet targets = new HashSet();
        if (this.listeners.containsKey(type)) {
            targets.addAll((Collection)this.listeners.get(type));
        }
        if (this.listeners.containsKey(DISPATCH_ALL)) {
            targets.addAll((Collection)this.listeners.get(DISPATCH_ALL));
        }
        for (SentenceListener listener : targets) {
            try {
                SentenceEvent se = new SentenceEvent(this, sentence);
                listener.sentenceRead(se);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, LOG_MSG, e);
            }
        }
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public int getPauseTimeout() {
        return this.pauseTimeout;
    }

    List<SentenceListener> getSentenceListeners() {
        HashSet all = new HashSet();
        for (List sl : this.listeners.values()) {
            all.addAll(sl);
        }
        return new ArrayList<SentenceListener>(all);
    }

    void handleException(String msg, Exception ex) {
        if (this.exceptionListener == null) {
            LOGGER.log(Level.WARNING, msg, ex);
        } else {
            try {
                this.exceptionListener.onException(ex);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception thrown by ExceptionListener", e);
            }
        }
    }

    private void registerListener(SentenceListener listener, String type) {
        if (this.listeners.containsKey(type)) {
            ((List)this.listeners.get(type)).add(listener);
        } else {
            Vector<SentenceListener> list = new Vector<SentenceListener>();
            list.add(listener);
            this.listeners.put(type, list);
        }
    }

    public void removeSentenceListener(SentenceListener listener) {
        for (List sl : this.listeners.values()) {
            sl.remove(listener);
        }
    }

    public void removeSentenceListener(SentenceListener listener, SentenceId sid) {
        this.removeSentenceListener(listener, sid.name());
    }

    public void removeSentenceListener(SentenceListener listener, String type) {
        List l = (List)this.listeners.get(type);
        if (l != null) {
            l.remove(listener);
        }
    }

    public void setDatagramSocket(DatagramSocket socket) {
        if (this.reader.isRunning()) {
            this.stop();
        }
        this.reader = new UDPDataReader(socket, this);
    }

    public void setDataListener(DataListener listener) {
        this.dataListener = listener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public void setInputStream(InputStream stream) {
        if (this.reader.isRunning()) {
            this.stop();
        }
        this.reader = new DefaultDataReader(stream, this);
    }

    public void setPauseTimeout(int millis) {
        this.pauseTimeout = millis;
    }

    public void start() {
        if (this.thread != null && this.thread.isAlive() && this.reader != null && this.reader.isRunning()) {
            throw new IllegalStateException("Reader is already running");
        }
        this.thread = new Thread(this.reader);
        this.thread.start();
    }

    public void stop() {
        if (this.reader != null && this.reader.isRunning()) {
            this.reader.stop();
        }
    }
}

