/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.io;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import net.sf.marineapi.nmea.io.AbstractDataReader;
import net.sf.marineapi.nmea.io.SentenceReader;

class UDPDataReader
extends AbstractDataReader {
    private DatagramSocket socket;
    private byte[] buffer = new byte[1024];
    private Queue<String> queue = new LinkedList<String>();

    UDPDataReader(DatagramSocket socket, SentenceReader parent) {
        super(parent);
        this.socket = socket;
    }

    @Override
    public String read() throws Exception {
        String data = null;
        while ((data = this.queue.poll()) == null) {
            data = this.receive();
            String[] lines = data.split("\\r?\\n");
            this.queue.addAll(Arrays.asList(lines));
        }
        return data;
    }

    private String receive() throws Exception {
        DatagramPacket pkg = new DatagramPacket(this.buffer, this.buffer.length);
        this.socket.receive(pkg);
        return new String(pkg.getData(), 0, pkg.getLength());
    }
}

