/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.AISSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;

abstract class AISParser
extends SentenceParser
implements AISSentence {
    private static final int NUMBER_OF_FRAGMENTS = 0;
    private static final int FRAGMENT_NUMBER = 1;
    private static final int MESSAGE_ID = 2;
    private static final int RADIO_CHANNEL = 3;
    private static final int PAYLOAD = 4;
    private static final int FILL_BITS = 5;

    public AISParser(String nmea, SentenceId sid) {
        super(nmea, sid);
    }

    public AISParser(TalkerId tid, SentenceId sid) {
        super('!', tid, sid, 6);
    }

    @Override
    public int getNumberOfFragments() {
        return this.getIntValue(0);
    }

    @Override
    public int getFragmentNumber() {
        return this.getIntValue(1);
    }

    @Override
    public String getMessageId() {
        return this.getStringValue(2);
    }

    @Override
    public String getRadioChannel() {
        return this.getStringValue(3);
    }

    @Override
    public String getPayload() {
        return this.getStringValue(4);
    }

    @Override
    public int getFillBits() {
        return this.getIntValue(5);
    }

    @Override
    public boolean isFragmented() {
        return this.getNumberOfFragments() > 1;
    }

    @Override
    public boolean isFirstFragment() {
        return this.getFragmentNumber() == 1;
    }

    @Override
    public boolean isLastFragment() {
        return this.getNumberOfFragments() == this.getFragmentNumber();
    }

    @Override
    public boolean isPartOfMessage(AISSentence line) {
        if (this.getNumberOfFragments() == line.getNumberOfFragments() && this.getFragmentNumber() < line.getFragmentNumber()) {
            if (this.getFragmentNumber() + 1 == line.getFragmentNumber()) {
                return this.getRadioChannel().equals(line.getRadioChannel()) || this.getMessageId().equals(line.getMessageId());
            }
            return this.getRadioChannel().equals(line.getRadioChannel()) && this.getMessageId().equals(line.getMessageId());
        }
        return false;
    }
}

