/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.APBSentence;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.DataStatus;
import net.sf.marineapi.nmea.util.Direction;

class APBParser
extends SentenceParser
implements APBSentence {
    private static final int SIGNAL_STATUS = 0;
    private static final int CYCLE_LOCK_STATUS = 1;
    private static final int XTE_DISTANCE = 2;
    private static final int XTE_STEER_TO = 3;
    private static final int XTE_UNITS = 4;
    private static final int CIRCLE_STATUS = 5;
    private static final int PERPENDICULAR_STATUS = 6;
    private static final int BEARING_ORIGIN_DEST = 7;
    private static final int BEARING_ORIGIN_DEST_TYPE = 8;
    private static final int DEST_WAYPOINT_ID = 9;
    private static final int BEARING_POS_DEST = 10;
    private static final int BEARING_POS_DEST_TYPE = 11;
    private static final int HEADING_TO_DEST = 12;
    private static final int HEADING_TO_DEST_TYPE = 13;

    public APBParser(String nmea) {
        super(nmea);
    }

    public APBParser(TalkerId talker) {
        super(talker, "APB", 14);
    }

    @Override
    public double getBearingPositionToDestination() {
        return this.getDoubleValue(10);
    }

    @Override
    public double getBearingOriginToDestination() {
        return this.getDoubleValue(7);
    }

    @Override
    public double getCrossTrackError() {
        return this.getDoubleValue(2);
    }

    @Override
    public char getCrossTrackUnits() {
        return this.getCharValue(4);
    }

    @Override
    public DataStatus getCycleLockStatus() {
        return DataStatus.valueOf(this.getCharValue(1));
    }

    @Override
    public String getDestionationWaypointId() {
        return this.getStringValue(9);
    }

    @Override
    public double getHeadingToDestionation() {
        return this.getDoubleValue(12);
    }

    @Override
    public DataStatus getStatus() {
        return DataStatus.valueOf(this.getCharValue(0));
    }

    @Override
    public Direction getSteerTo() {
        return Direction.valueOf(this.getCharValue(3));
    }

    @Override
    public boolean isArrivalCircleEntered() {
        return this.getCharValue(5) == 'A';
    }

    @Override
    public boolean isBearingOriginToDestionationTrue() {
        return this.getCharValue(8) == 'T';
    }

    @Override
    public boolean isBearingPositionToDestinationTrue() {
        return this.getCharValue(11) == 'T';
    }

    @Override
    public boolean isHeadingToDestinationTrue() {
        return this.getCharValue(13) == 'T';
    }

    @Override
    public boolean isPerpendicularPassed() {
        return this.getCharValue(6) == 'A';
    }

    @Override
    public void setArrivalCircleEntered(boolean isEntered) {
        DataStatus s = isEntered ? DataStatus.ACTIVE : DataStatus.VOID;
        this.setCharValue(5, s.toChar());
    }

    @Override
    public void setBearingOriginToDestination(double bearing) {
        this.setDegreesValue(7, bearing);
    }

    @Override
    public void setBearingOriginToDestionationTrue(boolean isTrue) {
        char c = isTrue ? (char)'T' : 'M';
        this.setCharValue(8, c);
    }

    @Override
    public void setBearingPositionToDestination(double bearing) {
        this.setDegreesValue(10, bearing);
    }

    @Override
    public void setBearingPositionToDestinationTrue(boolean isTrue) {
        char c = isTrue ? (char)'T' : 'M';
        this.setCharValue(11, c);
    }

    @Override
    public void setCrossTrackError(double distance) {
        this.setDoubleValue(2, distance, 1, 1);
    }

    @Override
    public void setCrossTrackUnits(char unit) {
        if (unit != 'K' && unit != 'N') {
            throw new IllegalAccessError("Invalid distance unit char, expected 'K' or 'N'");
        }
        this.setCharValue(4, unit);
    }

    @Override
    public void setCycleLockStatus(DataStatus status) {
        this.setCharValue(1, status.toChar());
    }

    @Override
    public void setDestinationWaypointId(String id) {
        this.setStringValue(9, id);
    }

    @Override
    public void setHeadingToDestination(double heading) {
        this.setDoubleValue(12, heading);
    }

    @Override
    public void setHeadingToDestinationTrue(boolean isTrue) {
        char c = isTrue ? (char)'T' : 'M';
        this.setCharValue(13, c);
    }

    @Override
    public void setPerpendicularPassed(boolean isPassed) {
        DataStatus s = isPassed ? DataStatus.ACTIVE : DataStatus.VOID;
        this.setCharValue(6, s.toChar());
    }

    @Override
    public void setStatus(DataStatus status) {
        this.setCharValue(0, status.toChar());
    }

    @Override
    public void setSteerTo(Direction direction) {
        this.setCharValue(3, direction.toChar());
    }
}

