/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.MHUSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;

class MHUParser
extends SentenceParser
implements MHUSentence {
    private static final int RELATIVE_HUMIDITY = 0;
    private static final int ABSOLUTE_HUMIDITY = 1;
    private static final int DEW_POINT = 2;
    private static final int DEW_POINT_UNIT = 3;

    public MHUParser(String nmea) {
        super(nmea, SentenceId.MHU);
    }

    public MHUParser(TalkerId tid) {
        super(tid, SentenceId.MHU, 4);
        this.setDewPointUnit('C');
    }

    @Override
    public double getRelativeHumidity() {
        return this.getDoubleValue(0);
    }

    @Override
    public double getAbsoluteHumidity() {
        return this.getDoubleValue(1);
    }

    @Override
    public double getDewPoint() {
        return this.getDoubleValue(2);
    }

    @Override
    public char getDewPointUnit() {
        return this.getCharValue(3);
    }

    @Override
    public void setRelativeHumidity(double humidity) {
        this.setDoubleValue(0, humidity, 1, 1);
    }

    @Override
    public void setAbsoluteHumidity(double humidity) {
        this.setDoubleValue(1, humidity, 1, 1);
    }

    @Override
    public void setDewPoint(double dewPoint) {
        this.setDoubleValue(2, dewPoint, 1, 1);
    }

    @Override
    public void setDewPointUnit(char unit) {
        this.setCharValue(3, unit);
    }
}

