/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import java.util.Arrays;
import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.RSDSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.DisplayRotation;
import net.sf.marineapi.nmea.util.Units;

class RSDParser
extends SentenceParser
implements RSDSentence {
    private static final int ORIGIN_ONE_RANGE = 0;
    private static final int ORIGIN_ONE_BEARING = 1;
    private static final int VRM_ONE_RANGE = 2;
    private static final int EBL_ONE_BEARING = 3;
    private static final int ORIGIN_TWO_RANGE = 4;
    private static final int ORIGIN_TWO_BEARING = 5;
    private static final int VRM_TWO_RANGE = 6;
    private static final int EBL_TWO_BEARING = 7;
    private static final int CURSOR_RANGE = 8;
    private static final int CURSOR_BEARING = 9;
    private static final int RANGE_SCALE = 10;
    private static final int RANGE_UNITS = 11;
    private static final int DISPLAY_ROTATION = 12;
    private static final Units[] VALID_RANGE_UNITS = new Units[]{Units.KILOMETERS, Units.NAUTICAL_MILES, Units.STATUTE_MILES};

    public RSDParser(String nmea) {
        super(nmea, SentenceId.RSD);
    }

    public RSDParser(TalkerId talker) {
        super(talker, SentenceId.RSD, 13);
    }

    @Override
    public double getOriginOneRange() {
        return this.getDoubleValue(0);
    }

    @Override
    public double getOriginOneBearing() {
        return this.getDoubleValue(1);
    }

    @Override
    public double getVRMOneRange() {
        return this.getDoubleValue(2);
    }

    @Override
    public double getEBLOneBearing() {
        return this.getDoubleValue(3);
    }

    @Override
    public double getOriginTwoRange() {
        return this.getDoubleValue(4);
    }

    @Override
    public double getOriginTwoBearing() {
        return this.getDoubleValue(5);
    }

    @Override
    public double getVRMTwoRange() {
        return this.getDoubleValue(6);
    }

    @Override
    public double getEBLTwoBearing() {
        return this.getDoubleValue(7);
    }

    @Override
    public double getCursorRange() {
        return this.getDoubleValue(8);
    }

    @Override
    public double getCursorBearing() {
        return this.getDoubleValue(9);
    }

    @Override
    public double getRangeScale() {
        return this.getDoubleValue(10);
    }

    @Override
    public Units getRangeUnits() {
        return Units.valueOf(this.getCharValue(11));
    }

    @Override
    public DisplayRotation getDisplayRotation() {
        return DisplayRotation.valueOf(this.getCharValue(12));
    }

    @Override
    public void setOriginOneRange(double range) {
        this.setDoubleValue(0, range);
    }

    @Override
    public void setOriginOneBearing(double bearing) {
        this.setDoubleValue(1, bearing);
    }

    @Override
    public void setVRMOneRange(double range) {
        this.setDoubleValue(2, range);
    }

    @Override
    public void setEBLOneBearing(double bearing) {
        this.setDoubleValue(3, bearing);
    }

    @Override
    public void setOriginTwoRange(double range) {
        this.setDoubleValue(4, range);
    }

    @Override
    public void setOriginTwoBearing(double bearing) {
        this.setDoubleValue(5, bearing);
    }

    @Override
    public void setVRMTwoRange(double range) {
        this.setDoubleValue(6, range);
    }

    @Override
    public void setEBLTwoBearing(double bearing) {
        this.setDoubleValue(7, bearing);
    }

    @Override
    public void setCursorRange(double range) {
        this.setDoubleValue(8, range);
    }

    @Override
    public void setCursorBearing(double bearing) {
        this.setDoubleValue(9, bearing);
    }

    @Override
    public void setRangeScale(double scale) {
        this.setDoubleValue(10, scale);
    }

    @Override
    public void setRangeUnits(Units units) {
        if (!Arrays.asList(VALID_RANGE_UNITS).contains((Object)units)) {
            String err = "Range units must be ";
            for (int i = 0; i < VALID_RANGE_UNITS.length; ++i) {
                Units u = VALID_RANGE_UNITS[i];
                err = err + u.name() + "(" + u.toChar() + ")";
                if (i == VALID_RANGE_UNITS.length - 1) continue;
                err = err + ", ";
            }
            throw new IllegalArgumentException(err);
        }
        this.setCharValue(11, units.toChar());
    }

    @Override
    public void setDisplayRotation(DisplayRotation rotation) {
        this.setCharValue(12, rotation.toChar());
    }
}

