/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import java.util.regex.Pattern;
import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TXTSentence;
import net.sf.marineapi.nmea.sentence.TalkerId;

class TXTParser
extends SentenceParser
implements TXTSentence {
    private static final Pattern ASCII = Pattern.compile("^[\\x20-\\x7F]*$");
    private static final int MESSAGE_COUNT = 0;
    private static final int MESSAGE_INDEX = 1;
    private static final int IDENTIFIER = 2;
    private static final int MESSAGE = 3;

    public TXTParser(String nmea) {
        super(nmea, SentenceId.TXT);
    }

    public TXTParser(TalkerId tid) {
        super(tid, SentenceId.TXT, 4);
    }

    @Override
    public int getMessageCount() {
        return this.getIntValue(0);
    }

    @Override
    public void setMessageCount(int count) {
        if (count < 1) {
            throw new IllegalArgumentException("Message count cannot be zero or negative");
        }
        this.setIntValue(0, count);
    }

    @Override
    public int getMessageIndex() {
        return this.getIntValue(1);
    }

    @Override
    public void setMessageIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Message index cannot be negative");
        }
        this.setIntValue(1, index);
    }

    @Override
    public String getIdentifier() {
        return this.getStringValue(2);
    }

    @Override
    public void setIdentifier(String id) {
        this.setStringValue(2, id);
    }

    @Override
    public String getMessage() {
        return this.getStringValue(3);
    }

    @Override
    public void setMessage(String msg) {
        if (!ASCII.matcher(msg).matches()) {
            throw new IllegalArgumentException("Message must be in ASCII character set");
        }
        this.setStringValue(3, msg);
    }
}

