/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.provider;

import net.sf.marineapi.nmea.io.SentenceReader;
import net.sf.marineapi.nmea.parser.DataNotAvailableException;
import net.sf.marineapi.nmea.sentence.GGASentence;
import net.sf.marineapi.nmea.sentence.GLLSentence;
import net.sf.marineapi.nmea.sentence.RMCSentence;
import net.sf.marineapi.nmea.sentence.Sentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.VTGSentence;
import net.sf.marineapi.nmea.util.DataStatus;
import net.sf.marineapi.nmea.util.Date;
import net.sf.marineapi.nmea.util.FaaMode;
import net.sf.marineapi.nmea.util.GpsFixQuality;
import net.sf.marineapi.nmea.util.Position;
import net.sf.marineapi.nmea.util.Time;
import net.sf.marineapi.provider.AbstractProvider;
import net.sf.marineapi.provider.event.PositionEvent;

public class PositionProvider
extends AbstractProvider<PositionEvent> {
    public PositionProvider(SentenceReader reader) {
        super(reader, SentenceId.RMC, SentenceId.GGA, SentenceId.GLL, SentenceId.VTG);
    }

    @Override
    protected PositionEvent createProviderEvent() {
        Position p = null;
        Double sog = null;
        Double cog = null;
        Date d = null;
        Time t = null;
        FaaMode mode = null;
        GpsFixQuality fix = null;
        for (Sentence s : this.getSentences()) {
            if (s instanceof RMCSentence) {
                RMCSentence rmc = (RMCSentence)s;
                sog = rmc.getSpeed();
                try {
                    cog = rmc.getCourse();
                }
                catch (DataNotAvailableException dataNotAvailableException) {
                    // empty catch block
                }
                d = rmc.getDate();
                t = rmc.getTime();
                if (p != null) continue;
                p = rmc.getPosition();
                if (rmc.getFieldCount() <= 11) continue;
                mode = rmc.getMode();
                continue;
            }
            if (s instanceof VTGSentence) {
                VTGSentence vtg = (VTGSentence)s;
                sog = vtg.getSpeedKnots();
                try {
                    cog = vtg.getTrueCourse();
                }
                catch (DataNotAvailableException dataNotAvailableException) {}
                continue;
            }
            if (s instanceof GGASentence) {
                GGASentence gga = (GGASentence)s;
                p = gga.getPosition();
                fix = gga.getFixQuality();
                if (t != null) continue;
                t = gga.getTime();
                continue;
            }
            if (!(s instanceof GLLSentence) || p != null) continue;
            GLLSentence gll = (GLLSentence)s;
            p = gll.getPosition();
        }
        if (d == null) {
            d = new Date();
        }
        return new PositionEvent(this, p, sog, cog, d, t, mode, fix);
    }

    @Override
    protected boolean isReady() {
        return this.hasOne("RMC", "VTG") && this.hasOne("GGA", "GLL");
    }

    @Override
    protected boolean isValid() {
        for (Sentence s : this.getSentences()) {
            DataStatus ds;
            GpsFixQuality fq;
            RMCSentence rmc;
            DataStatus ds2;
            if (!(s instanceof RMCSentence ? DataStatus.VOID.equals((Object)(ds2 = (rmc = (RMCSentence)s).getStatus())) || rmc.getFieldCount() > 11 && FaaMode.NONE.equals((Object)rmc.getMode()) : (s instanceof GGASentence ? GpsFixQuality.INVALID.equals((Object)(fq = ((GGASentence)s).getFixQuality())) : s instanceof GLLSentence && DataStatus.VOID.equals((Object)(ds = ((GLLSentence)s).getStatus()))))) continue;
            return false;
        }
        return true;
    }
}

