/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ublox.event;

import net.sf.marineapi.nmea.event.AbstractSentenceListener;
import net.sf.marineapi.nmea.sentence.UBXSentence;
import net.sf.marineapi.ublox.message.UBXMessage;
import net.sf.marineapi.ublox.parser.UBXMessageFactory;
import net.sf.marineapi.util.GenericTypeResolver;

public abstract class AbstractUBXMessageListener<T extends UBXMessage>
extends AbstractSentenceListener<UBXSentence> {
    final Class<?> messageType;
    private final UBXMessageFactory factory = UBXMessageFactory.getInstance();

    public AbstractUBXMessageListener() {
        this.messageType = GenericTypeResolver.resolve(this.getClass(), AbstractUBXMessageListener.class);
    }

    public AbstractUBXMessageListener(Class<T> c) {
        this.messageType = c;
    }

    @Override
    public final void sentenceRead(UBXSentence sentence) {
        try {
            UBXMessage message = this.factory.create(sentence);
            if (this.messageType.isAssignableFrom(message.getClass())) {
                this.onMessage(message);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public abstract void onMessage(T var1);

    @Override
    public void readingPaused() {
    }

    @Override
    public void readingStarted() {
    }

    @Override
    public void readingStopped() {
    }
}

