/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ublox.parser;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import net.sf.marineapi.nmea.sentence.UBXSentence;
import net.sf.marineapi.ublox.message.UBXMessage;
import net.sf.marineapi.ublox.parser.UBXMessage00Parser;
import net.sf.marineapi.ublox.parser.UBXMessage03Parser;
import net.sf.marineapi.ublox.parser.UBXMessageParser;

public class UBXMessageFactory {
    private static UBXMessageFactory instance;
    private Map<Integer, Class<? extends UBXMessage>> parsers = new HashMap<Integer, Class<? extends UBXMessage>>(2);

    private UBXMessageFactory() {
        this.parsers.put(0, UBXMessage00Parser.class);
        this.parsers.put(3, UBXMessage03Parser.class);
    }

    public UBXMessage create(UBXSentence sentence) {
        UBXMessage result;
        UBXMessageParser parser = new UBXMessageParser(sentence);
        if (!this.parsers.containsKey(parser.getMessageType())) {
            String msg = String.format("no parser for message type %d", parser.getMessageType());
            throw new IllegalArgumentException(msg);
        }
        Class<? extends UBXMessage> c = this.parsers.get(parser.getMessageType());
        try {
            Constructor<? extends UBXMessage> co = c.getConstructor(UBXSentence.class);
            result = co.newInstance(sentence);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getCause());
        }
        return result;
    }

    public static UBXMessageFactory getInstance() {
        if (instance == null) {
            instance = new UBXMessageFactory();
        }
        return instance;
    }
}

