/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.parser;

import net.sf.marineapi.ais.message.AISMessage21;
import net.sf.marineapi.ais.parser.AISMessageParser;
import net.sf.marineapi.ais.util.AISRuleViolation;
import net.sf.marineapi.ais.util.Latitude27;
import net.sf.marineapi.ais.util.Longitude28;
import net.sf.marineapi.ais.util.NavAidType;
import net.sf.marineapi.ais.util.Sixbit;

class AISMessage21Parser
extends AISMessageParser
implements AISMessage21 {
    private static final String SEPARATOR = "\n\t";
    private static final int AIDTYPE = 0;
    private static final int NAME = 1;
    private static final int POSITIONACCURACY = 2;
    private static final int LONGITUDE = 3;
    private static final int LATITUDE = 4;
    private static final int BOW = 5;
    private static final int STERN = 6;
    private static final int PORT = 7;
    private static final int STARBOARD = 8;
    private static final int TYPEOFEPFD = 9;
    private static final int UTC_SECOND = 10;
    private static final int OFFPOSITIONINDICATOR = 11;
    private static final int REGIONAL = 12;
    private static final int RAIMFLAG = 13;
    private static final int VIRTUALAIDFLAG = 14;
    private static final int ASSIGNEDMODEFLAG = 15;
    private static final int SPARE = 16;
    private static final int NAMEEXTENSION = 17;
    private static final int[] FROM = new int[]{38, 43, 163, 164, 192, 219, 228, 237, 243, 249, 253, 259, 260, 268, 269, 270, 271, 272};
    private static final int[] TO = new int[]{43, 163, 164, 192, 219, 228, 237, 243, 249, 253, 259, 260, 268, 269, 270, 271, 272, 360};
    private int fAidType;
    private String fName;
    private boolean fPositionAccuracy;
    private int fLongitude;
    private int fLatitude;
    private int fBow;
    private int fStern;
    private int fPort;
    private int fStarboard;
    private int fTypeOfEPFD;
    private int fUTCSecond;
    private boolean fOffPositionIndicator;
    private int fRegional;
    private boolean fRAIMFlag;
    private boolean fVirtualAidFlag;
    private boolean fAssignedModeFlag;
    private String fNameExtension;

    public AISMessage21Parser(Sixbit content) {
        super(content, 272, 361);
        this.fAidType = content.getInt(FROM[0], TO[0]);
        this.fName = content.getString(FROM[1], TO[1]);
        this.fPositionAccuracy = content.getBoolean(TO[2]);
        this.fLongitude = content.getAs28BitInt(FROM[3], TO[3]);
        if (!Longitude28.isCorrect(this.fLongitude)) {
            this.addViolation(new AISRuleViolation("LongitudeInDegrees", this.fLongitude, "[-108000000,108000000] + {108600000}"));
        }
        this.fLatitude = content.getAs27BitInt(FROM[4], TO[4]);
        if (!Latitude27.isCorrect(this.fLatitude)) {
            this.addViolation(new AISRuleViolation("LatitudeInDegrees", this.fLatitude, "[-54000000,54000000] + {54600000}"));
        }
        this.fBow = content.getInt(FROM[5], TO[5]);
        this.fStern = content.getInt(FROM[6], TO[6]);
        this.fPort = content.getInt(FROM[7], TO[7]);
        this.fStarboard = content.getInt(FROM[8], TO[8]);
        this.fTypeOfEPFD = content.getInt(FROM[9], TO[9]);
        this.fUTCSecond = content.getInt(FROM[10], TO[10]);
        this.fOffPositionIndicator = content.getBoolean(TO[11]);
        this.fRegional = content.getInt(FROM[12], TO[12]);
        this.fRAIMFlag = content.getBoolean(TO[13]);
        this.fVirtualAidFlag = content.getBoolean(TO[14]);
        this.fAssignedModeFlag = content.getBoolean(TO[15]);
        this.fNameExtension = content.getString(FROM[17], TO[17]).trim();
    }

    @Override
    public int getAidType() {
        return this.fAidType;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public boolean isAccurate() {
        return this.fPositionAccuracy;
    }

    @Override
    public double getLongitudeInDegrees() {
        return Longitude28.toDegrees(this.fLongitude);
    }

    @Override
    public double getLatitudeInDegrees() {
        return Latitude27.toDegrees(this.fLatitude);
    }

    @Override
    public int getBow() {
        return this.fBow;
    }

    @Override
    public int getStern() {
        return this.fStern;
    }

    @Override
    public int getPort() {
        return this.fPort;
    }

    @Override
    public int getStarboard() {
        return this.fStarboard;
    }

    @Override
    public int getTypeOfEPFD() {
        return this.fTypeOfEPFD;
    }

    @Override
    public int getUtcSecond() {
        return this.fUTCSecond;
    }

    @Override
    public boolean getOffPositionIndicator() {
        return this.fOffPositionIndicator;
    }

    @Override
    public int getRegional() {
        return this.fRegional;
    }

    @Override
    public boolean getRAIMFlag() {
        return this.fRAIMFlag;
    }

    @Override
    public boolean getVirtualAidFlag() {
        return this.fVirtualAidFlag;
    }

    @Override
    public boolean getAssignedModeFlag() {
        return this.fAssignedModeFlag;
    }

    @Override
    public String getNameExtension() {
        return this.fNameExtension;
    }

    @Override
    public boolean hasLongitude() {
        return Longitude28.isAvailable(this.fLongitude);
    }

    @Override
    public boolean hasLatitude() {
        return Latitude27.isAvailable(this.fLatitude);
    }

    public String toString() {
        String result = "\tAid Type:      " + NavAidType.toString(this.fAidType);
        result = result + "\n\tName:      " + this.fName;
        result = result + "\n\tPos acc: " + (this.fPositionAccuracy ? "high" : "low") + " accuracy";
        result = result + "\n\tLon:     " + Longitude28.toString(this.fLongitude);
        result = result + "\n\tLat:     " + Latitude27.toString(this.fLatitude);
        String dim = "Bow: " + this.fBow + ", Stern: " + this.fStern + ", Port: " + this.fPort + ", Starboard: " + this.fStarboard + " [m]";
        result = result + "\n\tDim:       " + dim;
        result = result + "\n\tSec:     " + this.getUtcSecond();
        result = result + "\n\tOff Position Indicator: " + (this.fOffPositionIndicator ? "yes" : "no");
        result = result + "\n\tRegional:     " + this.getRegional();
        result = result + "\n\tRAIM Flag: " + (this.fRAIMFlag ? "yes" : "no");
        result = result + "\n\tVirtual Aid Flag: " + (this.fVirtualAidFlag ? "yes" : "no");
        result = result + "\n\tAssigned Mode Flag: " + (this.fAssignedModeFlag ? "yes" : "no");
        result = result + "\n\tName Extension:      " + this.fNameExtension;
        return result;
    }
}

