/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.parser;

import net.sf.marineapi.ais.message.AISMessage27;
import net.sf.marineapi.ais.parser.AISMessageParser;
import net.sf.marineapi.ais.util.AISRuleViolation;
import net.sf.marineapi.ais.util.Angle12;
import net.sf.marineapi.ais.util.Angle9;
import net.sf.marineapi.ais.util.Latitude17;
import net.sf.marineapi.ais.util.Longitude18;
import net.sf.marineapi.ais.util.ManeuverIndicator;
import net.sf.marineapi.ais.util.NavigationalStatus;
import net.sf.marineapi.ais.util.RateOfTurn;
import net.sf.marineapi.ais.util.Sixbit;
import net.sf.marineapi.ais.util.SpeedOverGround;
import net.sf.marineapi.ais.util.TimeStamp;

class AisMessage27Parser
extends AISMessageParser
implements AISMessage27 {
    private static final String SEPARATOR = "\n\t";
    private static final int POSITIONACCURACY = 0;
    private static final int RAIMFLAG = 1;
    private static final int NAVIGATIONALSTATUS = 2;
    private static final int LONGITUDE = 3;
    private static final int LATITUDE = 4;
    private static final int SPEEDOVERGROUND = 5;
    private static final int COURSEOVERGROUND = 6;
    private static final int POSITIONLATENCY = 7;
    private static final int SPARE = 8;
    private static final int[] FROM = new int[]{38, 38, 49, 44, 62, 79, 85, 94, 95};
    private static final int[] TO = new int[]{38, 39, 44, 62, 79, 85, 94, 95, 96};
    private boolean fPositionAccuracy;
    private boolean fRaimFlag;
    private int fNavigationalStatus;
    private int fLongitude;
    private int fLatitude;
    private int fSOG;
    private int fCOG;
    private int fPositionLatency;
    private int fTrueHeading = 511;
    private int fRateOfTurn = -128;
    private int fTimeStamp = 60;
    private int fManouverIndicator = 0;

    public AisMessage27Parser(Sixbit content) {
        super(content, 96, 96);
        this.fPositionAccuracy = content.getBoolean(TO[0]);
        this.fRaimFlag = content.getBoolean(TO[1]);
        this.fNavigationalStatus = content.getInt(FROM[2], TO[2]);
        if (!NavigationalStatus.isCorrect(this.fNavigationalStatus)) {
            this.addViolation(new AISRuleViolation("NavigationalStatus", this.fNavigationalStatus, "[0,8] + [14,15]"));
        }
        this.fLongitude = content.getAs18BitInt(FROM[3], TO[3]);
        if (!Longitude18.isCorrect(this.fLongitude)) {
            this.addViolation(new AISRuleViolation("LongitudeInDegrees", this.fLongitude, "[-108000,108000] + {108600}"));
        }
        this.fLatitude = content.getAs17BitInt(FROM[4], TO[4]);
        if (!Latitude17.isCorrect(this.fLatitude)) {
            this.addViolation(new AISRuleViolation("LatitudeInDegrees", this.fLatitude, "[-54000,54000] + {54600}"));
        }
        this.fSOG = content.getInt(FROM[5], TO[5]);
        this.fCOG = content.getInt(FROM[6], TO[6]);
        if (!Angle9.isCorrect(this.fCOG)) {
            this.addViolation(new AISRuleViolation("CourseOverGround", this.fCOG, "[0,359] + {511}"));
        }
        this.fPositionLatency = content.getInt(FROM[7], TO[7]);
    }

    @Override
    public boolean getRAIMFlag() {
        return this.fRaimFlag;
    }

    @Override
    public int getNavigationalStatus() {
        return this.fNavigationalStatus;
    }

    @Override
    public double getRateOfTurn() {
        return RateOfTurn.toDegreesPerMinute(this.fRateOfTurn);
    }

    @Override
    public double getSpeedOverGround() {
        return this.fSOG;
    }

    @Override
    public boolean isAccurate() {
        return this.fPositionAccuracy;
    }

    @Override
    public double getLongitudeInDegrees() {
        return Longitude18.toDegrees(this.fLongitude);
    }

    @Override
    public double getLatitudeInDegrees() {
        return Latitude17.toDegrees(this.fLatitude);
    }

    @Override
    public double getCourseOverGround() {
        return this.fCOG;
    }

    @Override
    public int getTrueHeading() {
        return this.fTrueHeading;
    }

    @Override
    public int getTimeStamp() {
        return this.fTimeStamp;
    }

    @Override
    public int getManouverIndicator() {
        return this.fManouverIndicator;
    }

    @Override
    public boolean hasRateOfTurn() {
        return RateOfTurn.isTurnIndicatorAvailable(this.fRateOfTurn);
    }

    @Override
    public boolean hasSpeedOverGround() {
        return SpeedOverGround.isAvailable(this.fSOG);
    }

    @Override
    public boolean hasCourseOverGround() {
        return Angle12.isAvailable(this.fCOG);
    }

    @Override
    public boolean hasTrueHeading() {
        return Angle9.isAvailable(this.fTrueHeading);
    }

    @Override
    public boolean hasTimeStamp() {
        return TimeStamp.isAvailable(this.fTimeStamp);
    }

    @Override
    public boolean hasLongitude() {
        return Longitude18.isAvailable(this.fLongitude);
    }

    @Override
    public boolean hasLatitude() {
        return Latitude17.isAvailable(this.fLatitude);
    }

    @Override
    public int getPositionLatency() {
        return this.fPositionLatency;
    }

    public String toString() {
        String result = "\tNav st:  " + NavigationalStatus.toString(this.fNavigationalStatus);
        result = result + "\n\tROT:     " + RateOfTurn.toString(this.fRateOfTurn);
        result = result + "\n\tSOG:     " + SpeedOverGround.toString(this.fSOG);
        result = result + "\n\tPos acc: " + (this.fPositionAccuracy ? "high" : "low") + " accuracy";
        result = result + "\n\tLon:     " + Longitude18.toString(this.fLongitude);
        result = result + "\n\tLat:     " + Latitude17.toString(this.fLatitude);
        result = result + "\n\tCOG:     " + Angle9.toString(this.fCOG);
        result = result + "\n\tHeading: " + Angle9.getTrueHeadingString(this.fTrueHeading);
        result = result + "\n\tTime:    " + TimeStamp.toString(this.fTimeStamp);
        result = result + "\n\tMan ind: " + ManeuverIndicator.toString(this.fManouverIndicator);
        result = result + "\n\tLatency: " + (this.fPositionLatency == 0 ? "<5s" : ">5s");
        return result;
    }
}

