/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.util;

import java.text.DecimalFormat;

public class Latitude27 {
    private static final DecimalFormat COORD_FORMAT = new DecimalFormat("##0.000000;-##0.000000");
    private static final int MINUTE_PART_MULTIPLIER = 600000;
    private static final int MIN_VALUE = -54000000;
    private static final int MAX_VALUE = 54000000;
    private static final int DEFAULT_VALUE = 54600000;
    public static final String RANGE = "[-54000000,54000000] + {54600000}";

    public static double toDegrees(int value) {
        return (double)value / 600000.0;
    }

    public static boolean isAvailable(int value) {
        return value >= -54000000 && value <= 54000000;
    }

    public static boolean isCorrect(int value) {
        return Latitude27.isAvailable(value) || value == 54600000;
    }

    public static String toString(int value) {
        if (!Latitude27.isCorrect(value)) {
            return "invalid latitude";
        }
        if (!Latitude27.isAvailable(value)) {
            return "latitude not available";
        }
        return COORD_FORMAT.format(Latitude27.toDegrees(value));
    }
}

