/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.util;

import java.text.DecimalFormat;

public class Longitude28 {
    private static final DecimalFormat COORD_FORMAT = new DecimalFormat("##0.000000;-##0.000000");
    private static final int MINUTE_PART_MULTIPLIER = 600000;
    private static final int MIN_VALUE = -108000000;
    private static final int MAX_VALUE = 108000000;
    private static final int DEFAULT_VALUE = 108600000;
    public static final String RANGE = "[-108000000,108000000] + {108600000}";

    public static double toDegrees(int value) {
        return (double)value / 600000.0;
    }

    public static boolean isAvailable(int value) {
        return value >= -108000000 && value <= 108000000;
    }

    public static boolean isCorrect(int value) {
        return Longitude28.isAvailable(value) || value == 108600000;
    }

    public static String toString(int value) {
        if (!Longitude28.isCorrect(value)) {
            return "invalid longitude";
        }
        if (!Longitude28.isAvailable(value)) {
            return "longitude not available";
        }
        return COORD_FORMAT.format(Longitude28.toDegrees(value));
    }
}

