/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.util;

public class RateOfTurn {
    private static final int DEFAULTVALUE = -128;
    private static final int MINVALUE = -126;
    private static final int MAXVALUE = 126;

    public static boolean isTurnInformationAvailable(int value) {
        return value != -128;
    }

    public static boolean isTurnIndicatorAvailable(int value) {
        return -126 <= value && value <= 126;
    }

    public static double toDegreesPerMinute(int value) {
        if (RateOfTurn.isTurnIndicatorAvailable(value)) {
            double v = (double)value / 4.733;
            double v2 = v * v;
            if (value < 0) {
                return -v2;
            }
            return v2;
        }
        return 0.0;
    }

    public static String toString(int value) {
        String direction = value < 0 ? "left" : "right";
        switch (Math.abs(value)) {
            case 128: {
                return "no turn information available (default)";
            }
            case 127: {
                return "turning " + direction + " at more than 5 degrees per 30 s (No TI available)";
            }
            case 126: {
                return "turning " + direction + " at 708 degrees per min or higher";
            }
            case 0: {
                return "not turning";
            }
        }
        return "turning " + direction + " at " + Math.abs(RateOfTurn.toDegreesPerMinute(value)) + " degrees per min";
    }
}

