/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.example;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.sf.marineapi.ais.event.AbstractAISMessageListener;
import net.sf.marineapi.ais.message.AISMessage01;
import net.sf.marineapi.nmea.io.SentenceReader;

public class AISListenerExample
extends AbstractAISMessageListener<AISMessage01> {
    private SentenceReader reader;

    public AISListenerExample(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        this.reader = new SentenceReader(stream);
        this.reader.addSentenceListener(this);
        this.reader.start();
    }

    @Override
    public void onMessage(AISMessage01 msg) {
        System.out.println(msg.getMMSI() + ": " + msg.getLatitudeInDegrees());
        System.out.println("onMessage: " + msg.toString());
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Example usage:\njava AISExample ais.log");
            System.exit(1);
        }
        try {
            new AISListenerExample(new File(args[0]));
            System.out.println("Running, press CTRL-C to stop..");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

