/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.example;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.sf.marineapi.nmea.io.SentenceReader;
import net.sf.marineapi.nmea.util.SatelliteInfo;
import net.sf.marineapi.provider.SatelliteInfoProvider;
import net.sf.marineapi.provider.event.SatelliteInfoEvent;
import net.sf.marineapi.provider.event.SatelliteInfoListener;

public class SatelliteInfoProviderExample
implements SatelliteInfoListener {
    SentenceReader reader;
    SatelliteInfoProvider provider;

    public SatelliteInfoProviderExample(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        this.reader = new SentenceReader(stream);
        this.provider = new SatelliteInfoProvider(this.reader);
        this.provider.addListener(this);
        this.reader.start();
    }

    @Override
    public void providerUpdate(SatelliteInfoEvent event) {
        System.out.println("-- GSV report --");
        for (SatelliteInfo si : event.getSatelliteInfo()) {
            String ptrn = "%s: %d, %d";
            String msg = String.format(ptrn, si.getId(), si.getAzimuth(), si.getElevation());
            System.out.println(msg);
        }
        System.out.println("-----");
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            String msg = "Example usage:\njava SatelliteInfoProviderExample nmea.log";
            System.out.println(msg);
            System.exit(0);
        }
        try {
            new SatelliteInfoProviderExample(new File(args[0]));
            System.out.println("Running, press CTRL-C to stop..");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

