/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.example;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.sf.marineapi.nmea.event.AbstractSentenceListener;
import net.sf.marineapi.nmea.io.SentenceReader;
import net.sf.marineapi.nmea.sentence.RMCSentence;

public class TypedSentenceListenerExample
extends AbstractSentenceListener<RMCSentence> {
    private SentenceReader reader;

    public TypedSentenceListenerExample(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        this.reader = new SentenceReader(stream);
        this.reader.addSentenceListener(this);
        this.reader.start();
    }

    @Override
    public void sentenceRead(RMCSentence sentence) {
        System.out.println(sentence.getPosition());
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage:\njava TypedSentenceListenerExample <file>");
            System.exit(1);
        }
        try {
            new TypedSentenceListenerExample(new File(args[0]));
            System.out.println("Running, press CTRL-C to stop..");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

