/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.example;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.sf.marineapi.nmea.io.SentenceReader;
import net.sf.marineapi.nmea.util.Position;
import net.sf.marineapi.ublox.event.AbstractUBXMessageListener;
import net.sf.marineapi.ublox.message.UBXMessage00;
import net.sf.marineapi.ublox.message.UBXMessage03;

public class UBXListenerExample {
    private SentenceReader reader;

    public UBXListenerExample(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        this.reader = new SentenceReader(stream);
        this.reader.addSentenceListener(new UBXMessage00Listener());
        this.reader.addSentenceListener(new UBXMessage03Listener());
        this.reader.start();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Exactly 1 argument is required. Example usage:\njava UBXListenerExample pubx.log");
            System.exit(1);
        }
        try {
            new UBXListenerExample(new File(args[0]));
            System.out.println("Running, press CTRL-C to stop..");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    class UBXMessage00Listener
    extends AbstractUBXMessageListener<UBXMessage00> {
        UBXMessage00Listener() {
        }

        @Override
        public void onMessage(UBXMessage00 msg) {
            Position position = msg.getPosition();
            System.out.println(position.getLongitude() + " : " + position.getLatitude());
            System.out.println("onMessage: " + msg.toString());
        }
    }

    class UBXMessage03Listener
    extends AbstractUBXMessageListener<UBXMessage03> {
        UBXMessage03Listener() {
        }

        @Override
        public void onMessage(UBXMessage03 msg) {
            int numberOfTrackedSatellites = msg.getNumberOfTrackedSatellites();
            System.out.println(String.format("Tracking %s satellites.", numberOfTrackedSatellites));
            System.out.println("onMessage: " + msg.toString());
        }
    }
}

