/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.io;

import java.util.logging.Logger;
import net.sf.marineapi.nmea.io.ActivityMonitor;
import net.sf.marineapi.nmea.io.SentenceReader;
import net.sf.marineapi.nmea.parser.SentenceFactory;
import net.sf.marineapi.nmea.parser.UnsupportedSentenceException;
import net.sf.marineapi.nmea.sentence.Sentence;
import net.sf.marineapi.nmea.sentence.SentenceValidator;

public abstract class AbstractDataReader
implements Runnable {
    private static final int SLEEP_TIME = 100;
    private static final Logger LOGGER = Logger.getLogger(AbstractDataReader.class.getName());
    private SentenceReader parent;
    private volatile boolean isRunning = true;

    protected AbstractDataReader() {
    }

    AbstractDataReader(SentenceReader parent) {
        this.setParent(parent);
    }

    SentenceReader getParent() {
        return this.parent;
    }

    void setParent(SentenceReader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("Parent SentenceReader cannot be set null");
        }
        this.parent = reader;
    }

    boolean isRunning() {
        return this.isRunning;
    }

    public abstract String read() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ActivityMonitor monitor = new ActivityMonitor(this.parent);
        SentenceFactory factory = SentenceFactory.getInstance();
        while (this.isRunning) {
            try {
                String data = this.read();
                if (data == null) {
                    Thread.sleep(100L);
                    continue;
                }
                if (SentenceValidator.isValid(data)) {
                    monitor.refresh();
                    Sentence s = factory.createParser(data);
                    this.parent.fireSentenceEvent(s);
                    continue;
                }
                if (SentenceValidator.isSentence(data)) continue;
                this.parent.fireDataEvent(data);
            }
            catch (UnsupportedSentenceException use) {
                LOGGER.warning(use.getMessage());
            }
            catch (Exception e) {
                this.parent.handleException("Data read failed", e);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                monitor.tick();
            }
        }
        monitor.reset();
        this.parent.fireReadingStopped();
    }

    public void stop() {
        this.isRunning = false;
    }
}

