/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.marineapi.nmea.parser.ParseException;
import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.DTASentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;

class DTAParser
extends SentenceParser
implements DTASentence {
    private static final int CHANNEL_NUMBER = 0;
    private static final int GAS_CONCENTRATION = 1;
    private static final int CONFIDENCE_FACTOR_R2 = 2;
    private static final int DISTANCE = 3;
    private static final int LIGHT_LEVEL = 4;
    private static final int DATE_TIME = 5;
    private static final int SER_NUMBER = 6;
    private static final int STATUS_CODE = 7;
    private static final DateFormat DATE_PARSER = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private int offset = this.getFieldCount() >= 8 ? 0 : -1;

    public DTAParser(TalkerId talker) {
        super(talker, SentenceId.DTA, 8);
    }

    public DTAParser(String nmea) {
        super(nmea, SentenceId.DTA);
    }

    protected DTAParser(String nmea, SentenceId type) {
        super(nmea, type);
    }

    protected DTAParser(TalkerId talker, SentenceId type, int size) {
        super(talker, type, size);
    }

    private int getFieldIndex(int field) {
        return this.offset + field;
    }

    @Override
    public int getChannelNumber() {
        if (this.offset == -1) {
            return 1;
        }
        return this.getIntValue(0);
    }

    @Override
    public double getGasConcentration() {
        return this.getDoubleValue(this.getFieldIndex(1));
    }

    @Override
    public int getConfidenceFactorR2() {
        return this.getIntValue(this.getFieldIndex(2));
    }

    @Override
    public double getDistance() {
        return this.getDoubleValue(this.getFieldIndex(3));
    }

    @Override
    public int getLightLevel() {
        return this.getIntValue(this.getFieldIndex(4));
    }

    @Override
    public Date getDateTime() {
        Date value;
        try {
            value = DATE_PARSER.parse(this.getStringValue(this.getFieldIndex(5)));
        }
        catch (java.text.ParseException ex) {
            throw new ParseException("Field does not contain date value", ex);
        }
        return value;
    }

    @Override
    public String getSerialNumber() {
        return this.getStringValue(this.getFieldIndex(6));
    }

    @Override
    public int getStatusCode() {
        return this.getIntValue(this.getFieldIndex(7));
    }
}

