/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.DTMSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;

class DTMParser
extends SentenceParser
implements DTMSentence {
    private static final int DATUM_CODE = 0;
    private static final int DATUM_SUBCODE = 1;
    private static final int LATITUDE_OFFSET = 2;
    private static final int LAT_OFFSET_HEMISPHERE = 3;
    private static final int LONGITUDE_OFFSET = 4;
    private static final int LON_OFFSET_HEMISPHERE = 5;
    private static final int ALTITUDE_OFFSET = 6;
    private static final int DATUM_NAME = 7;

    public DTMParser(String nmea) {
        super(nmea, SentenceId.DTM);
    }

    public DTMParser(TalkerId talker) {
        super(talker, SentenceId.DTM, 8);
    }

    @Override
    public double getAltitudeOffset() {
        return this.getDoubleValue(6);
    }

    @Override
    public String getDatumCode() {
        return this.getStringValue(0);
    }

    @Override
    public String getDatumSubCode() {
        return this.getStringValue(1);
    }

    @Override
    public double getLatitudeOffset() {
        return this.getDoubleValue(2);
    }

    @Override
    public double getLongitudeOffset() {
        return this.getDoubleValue(4);
    }

    @Override
    public String getName() {
        return this.getStringValue(7);
    }

    @Override
    public void setDatumCode(String code) {
        this.setStringValue(0, code);
    }

    @Override
    public void setDatumSubCode(String code) {
        this.setStringValue(1, code);
    }

    @Override
    public void setLatitudeOffset(double offset) {
        this.setDoubleValue(2, offset, 1, 4);
        if (offset < 0.0) {
            this.setCharValue(3, 'S');
        } else {
            this.setCharValue(3, 'N');
        }
    }

    @Override
    public void setLongitudeOffset(double offset) {
        this.setDoubleValue(4, offset, 1, 4);
        if (offset < 0.0) {
            this.setCharValue(5, 'W');
        } else {
            this.setCharValue(5, 'E');
        }
    }

    @Override
    public void setName(String name) {
        this.setStringValue(7, name);
    }
}

