/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.PositionParser;
import net.sf.marineapi.nmea.sentence.GNSSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.Position;
import net.sf.marineapi.nmea.util.Time;

class GNSParser
extends PositionParser
implements GNSSentence {
    private static final int UTC_TIME = 0;
    private static final int LATITUDE = 1;
    private static final int LAT_DIRECTION = 2;
    private static final int LONGITUDE = 3;
    private static final int LON_DIRECTION = 4;
    private static final int MODE = 5;
    private static final int SATELLITE_COUNT = 6;
    private static final int HDOP = 7;
    private static final int ORTHOMETRIC_HEIGHT = 8;
    private static final int GEOIDAL_SEPARATION = 9;
    private static final int DGPS_AGE = 10;
    private static final int DGPS_STATION = 11;
    private static final int GPS_MODE = 0;
    private static final int GNS_MODE = 1;
    private static final int VAR_MODE = 2;

    public GNSParser(String nmea) {
        super(nmea, SentenceId.GNS);
    }

    public GNSParser(TalkerId tid) {
        super(tid, SentenceId.GNS, 12);
        this.setTime(new Time());
        this.setStringValue(5, "NN");
    }

    @Override
    public Time getTime() {
        return new Time(this.getStringValue(0));
    }

    @Override
    public void setTime(Time t) {
        this.setStringValue(0, t.toString());
    }

    @Override
    public Position getPosition() {
        return this.parsePosition(1, 2, 3, 4);
    }

    @Override
    public void setPosition(Position pos) {
        this.setPositionValues(pos, 1, 2, 3, 4);
    }

    @Override
    public GNSSentence.Mode getGpsMode() {
        String modes = this.getStringValue(5);
        return GNSSentence.Mode.valueOf(modes.charAt(0));
    }

    @Override
    public void setGpsMode(GNSSentence.Mode gps) {
        String modes = this.getStringValue(5);
        this.setStringValue(5, gps.toChar() + modes.substring(1));
    }

    @Override
    public GNSSentence.Mode getGlonassMode() {
        String modes = this.getStringValue(5);
        return GNSSentence.Mode.valueOf(modes.charAt(1));
    }

    @Override
    public void setGlonassMode(GNSSentence.Mode gns) {
        String modes = this.getStringValue(5);
        StringBuffer sb = new StringBuffer(modes.length());
        sb.append(modes.charAt(0));
        sb.append(gns.toChar());
        if (modes.length() > 2) {
            sb.append(modes.substring(2));
        }
        this.setStringValue(5, sb.toString());
    }

    @Override
    public GNSSentence.Mode[] getAdditionalModes() {
        String mode = this.getStringValue(5);
        if (mode.length() == 2) {
            return new GNSSentence.Mode[0];
        }
        String additional = mode.substring(2);
        GNSSentence.Mode[] modes = new GNSSentence.Mode[additional.length()];
        for (int i = 0; i < additional.length(); ++i) {
            modes[i] = GNSSentence.Mode.valueOf(additional.charAt(i));
        }
        return modes;
    }

    @Override
    public void setAdditionalModes(GNSSentence.Mode ... modes) {
        String current = this.getStringValue(5);
        StringBuffer sb = new StringBuffer(modes.length + 2);
        sb.append(current.substring(0, 2));
        for (GNSSentence.Mode m : modes) {
            sb.append(m.toChar());
        }
        this.setStringValue(5, sb.toString());
    }

    @Override
    public int getSatelliteCount() {
        return this.getIntValue(6);
    }

    @Override
    public void setSatelliteCount(int count) {
        this.setIntValue(6, count, 2);
    }

    @Override
    public double getHorizontalDOP() {
        return this.getDoubleValue(7);
    }

    @Override
    public void setHorizontalDOP(double hdop) {
        this.setDoubleValue(7, hdop, 1, 2);
    }

    @Override
    public double getOrthometricHeight() {
        return this.getDoubleValue(8);
    }

    @Override
    public void setOrthometricHeight(double height) {
        this.setDoubleValue(8, height, 1, 2);
    }

    @Override
    public double getGeoidalSeparation() {
        return this.getDoubleValue(9);
    }

    @Override
    public void setGeoidalSeparation(double separation) {
        this.setDoubleValue(9, separation, 1, 2);
    }

    @Override
    public double getDgpsAge() {
        return this.getDoubleValue(10);
    }

    @Override
    public void setDgpsAge(double age) {
        this.setDoubleValue(10, age, 1, 1);
    }

    @Override
    public String getDgpsStationId() {
        return this.getStringValue(11);
    }

    @Override
    public void setDgpsStationId(String stationId) {
        this.setStringValue(11, stationId);
    }
}

