/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.GSTSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.Time;

class GSTParser
extends SentenceParser
implements GSTSentence {
    private static final int UTC_TIME = 0;
    private static final int PSEUDORANGE_RESIDUALS_RMS = 1;
    private static final int ERROR_ELLIPSE_SEMI_MAJOR = 2;
    private static final int ERROR_ELLIPSE_SEMI_MINOR = 3;
    private static final int ERROR_ELLIPSE_ORIENTATION = 4;
    private static final int LATITUDE_ERROR = 5;
    private static final int LONGITUDE_ERROR = 6;
    private static final int ALTITUDE_ERROR = 7;

    public GSTParser(String nmea) {
        super(nmea, SentenceId.GST);
    }

    public GSTParser(TalkerId talker) {
        super(talker, SentenceId.GST, 8);
    }

    @Override
    public Time getTime() {
        String str = this.getStringValue(0);
        return new Time(str);
    }

    @Override
    public double getPseudoRangeResidualsRMS() {
        return this.getDoubleValue(1);
    }

    @Override
    public double getSemiMajorError() {
        return this.getDoubleValue(2);
    }

    @Override
    public double getSemiMinorError() {
        return this.getDoubleValue(3);
    }

    @Override
    public double getErrorEllipseOrientation() {
        return this.getDoubleValue(4);
    }

    @Override
    public double getLatitudeError() {
        return this.getDoubleValue(5);
    }

    @Override
    public double getLongitudeError() {
        return this.getDoubleValue(6);
    }

    @Override
    public double getAltitudeError() {
        return this.getDoubleValue(7);
    }

    @Override
    public void setTime(Time t) {
        this.setStringValue(0, t.toString());
    }

    @Override
    public void setPseudoRangeResidualsRMS(double rms) {
        this.setDoubleValue(1, rms);
    }

    @Override
    public void setSemiMajorError(double error) {
        this.setDoubleValue(2, error);
    }

    @Override
    public void setSemiMinorError(double error) {
        this.setDoubleValue(3, error);
    }

    @Override
    public void setErrorEllipseOrientation(double orientation) {
        this.setDoubleValue(4, orientation);
    }

    @Override
    public void setLatitudeError(double error) {
        this.setDoubleValue(5, error);
    }

    @Override
    public void setLongitudeError(double error) {
        this.setDoubleValue(6, error);
    }

    @Override
    public void setAltitudeError(double error) {
        this.setDoubleValue(7, error);
    }
}

