/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.HTCParser;
import net.sf.marineapi.nmea.sentence.HTDSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.DataStatus;

class HTDParser
extends HTCParser
implements HTDSentence {
    private static final int RUDDER_STATUS = 13;
    private static final int OFF_HEADING_STATUS = 14;
    private static final int OFF_TRACK_STATUS = 15;
    private static final int HEADING = 16;

    public HTDParser(String nmea) {
        super(nmea, SentenceId.HTD);
    }

    public HTDParser(TalkerId talker) {
        super(talker, SentenceId.HTD, 17);
    }

    @Override
    public DataStatus getRudderStatus() {
        if (this.hasValue(13)) {
            return DataStatus.valueOf(this.getCharValue(13));
        }
        return null;
    }

    @Override
    public DataStatus getOffHeadingStatus() {
        if (this.hasValue(14)) {
            return DataStatus.valueOf(this.getCharValue(14));
        }
        return null;
    }

    @Override
    public DataStatus getOffTrackStatus() {
        if (this.hasValue(15)) {
            return DataStatus.valueOf(this.getCharValue(15));
        }
        return null;
    }

    @Override
    public double getHeading() {
        if (this.hasValue(16)) {
            return this.getDoubleValue(16);
        }
        return Double.NaN;
    }

    @Override
    public boolean isTrue() {
        return this.isHeadingTrue();
    }

    @Override
    public void setHeading(double hdt) {
        this.setDoubleValue(16, hdt);
    }
}

