/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.MMBSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;

class MMBParser
extends SentenceParser
implements MMBSentence {
    private static final int PRESSURE_INHG = 0;
    private static final int UNIT_INHG = 1;
    private static final int PRESSURE_BARS = 2;
    private static final int UNIT_BARS = 3;

    public MMBParser(String nmea) {
        super(nmea, SentenceId.MMB);
    }

    public MMBParser(TalkerId tid) {
        super(tid, SentenceId.MMB, 4);
        this.setCharValue(1, 'I');
        this.setCharValue(3, 'B');
    }

    @Override
    public double getInchesOfMercury() {
        return this.getDoubleValue(0);
    }

    @Override
    public double getBars() {
        return this.getDoubleValue(2);
    }

    @Override
    public void setInchesOfMercury(double inHg) {
        this.setDoubleValue(0, inHg);
    }

    @Override
    public void setBars(double bars) {
        this.setDoubleValue(2, bars);
    }
}

