/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.PositionParser;
import net.sf.marineapi.nmea.sentence.RMBSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.DataStatus;
import net.sf.marineapi.nmea.util.Direction;
import net.sf.marineapi.nmea.util.Position;
import net.sf.marineapi.nmea.util.Waypoint;

class RMBParser
extends PositionParser
implements RMBSentence {
    private static final int STATUS = 0;
    private static final int CROSS_TRACK_ERROR = 1;
    private static final int STEER_TO = 2;
    private static final int ORIGIN_WPT = 3;
    private static final int DEST_WPT = 4;
    private static final int DEST_LAT = 5;
    private static final int DEST_LAT_HEM = 6;
    private static final int DEST_LON = 7;
    private static final int DEST_LON_HEM = 8;
    private static final int RANGE_TO_DEST = 9;
    private static final int BEARING_TO_DEST = 10;
    private static final int VELOCITY = 11;
    private static final int ARRIVAL_STATUS = 12;

    public RMBParser(String nmea) {
        super(nmea, SentenceId.RMB);
    }

    public RMBParser(TalkerId talker) {
        super(talker, SentenceId.RMB, 13);
    }

    @Override
    public DataStatus getArrivalStatus() {
        return DataStatus.valueOf(this.getCharValue(12));
    }

    @Override
    public double getBearing() {
        return this.getDoubleValue(10);
    }

    @Override
    public double getCrossTrackError() {
        return this.getDoubleValue(1);
    }

    @Override
    public Waypoint getDestination() {
        String id = this.getStringValue(4);
        Position p = this.parsePosition(5, 6, 7, 8);
        return p.toWaypoint(id);
    }

    @Override
    public String getOriginId() {
        return this.getStringValue(3);
    }

    @Override
    public double getRange() {
        return this.getDoubleValue(9);
    }

    @Override
    public DataStatus getStatus() {
        return DataStatus.valueOf(this.getCharValue(0));
    }

    @Override
    public Direction getSteerTo() {
        return Direction.valueOf(this.getCharValue(2));
    }

    @Override
    public double getVelocity() {
        return this.getDoubleValue(11);
    }

    @Override
    public boolean hasArrived() {
        return DataStatus.ACTIVE.equals((Object)this.getArrivalStatus());
    }

    @Override
    public void setArrivalStatus(DataStatus status) {
        this.setCharValue(12, status.toChar());
    }

    @Override
    public void setBearing(double bearing) {
        this.setDegreesValue(10, bearing);
    }

    @Override
    public void setCrossTrackError(double xte) {
        this.setDoubleValue(1, xte, 1, 2);
    }

    @Override
    public void setDestination(Waypoint dest) {
        this.setStringValue(4, dest.getId());
        this.setPositionValues(dest, 5, 6, 7, 8);
    }

    @Override
    public void setOriginId(String id) {
        this.setStringValue(3, id);
    }

    @Override
    public void setRange(double range) {
        this.setDoubleValue(9, range, 1, 1);
    }

    @Override
    public void setStatus(DataStatus status) {
        this.setCharValue(0, status.toChar());
    }

    @Override
    public void setSteerTo(Direction steer) {
        if (steer != Direction.LEFT && steer != Direction.RIGHT) {
            throw new IllegalArgumentException("Expected steer-to is LEFT or RIGHT.");
        }
        this.setCharValue(2, steer.toChar());
    }

    @Override
    public void setVelocity(double velocity) {
        this.setDoubleValue(11, velocity, 1, 1);
    }
}

