/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import net.sf.marineapi.nmea.parser.PositionParser;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TLLSentence;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.Position;
import net.sf.marineapi.nmea.util.TargetStatus;
import net.sf.marineapi.nmea.util.Time;

class TLLParser
extends PositionParser
implements TLLSentence {
    private static final int NUMBER = 0;
    private static final int LATITUDE = 1;
    private static final int LAT_HEMISPHERE = 2;
    private static final int LONGITUDE = 3;
    private static final int LON_HEMISPHERE = 4;
    private static final int NAME = 5;
    private static final int UTC_TIME = 6;
    private static final int STATUS = 7;
    private static final int REFERENCE = 8;

    public TLLParser(String nmea) {
        super(nmea, SentenceId.TLL);
    }

    public TLLParser(TalkerId talker) {
        super(talker, SentenceId.TLL, 9);
    }

    @Override
    public Position getPosition() {
        return this.parsePosition(1, 2, 3, 4);
    }

    @Override
    public void setPosition(Position pos) {
        this.setPositionValues(pos, 1, 2, 3, 4);
    }

    @Override
    public int getNumber() {
        return this.getIntValue(0);
    }

    @Override
    public String getName() {
        return this.getStringValue(5);
    }

    @Override
    public TargetStatus getStatus() {
        return TargetStatus.valueOf(this.getCharValue(7));
    }

    @Override
    public boolean getReference() {
        return this.getCharValue(8) == 'R';
    }

    @Override
    public Time getTime() {
        String str = this.getStringValue(6);
        return new Time(str);
    }

    @Override
    public void setNumber(int number) {
        this.setIntValue(0, number, 2);
    }

    @Override
    public void setName(String name) {
        this.setStringValue(5, name);
    }

    @Override
    public void setTime(Time t) {
        String str = String.format("%02d%02d", t.getHour(), t.getMinutes());
        DecimalFormat nf = new DecimalFormat("00.00");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        nf.setDecimalFormatSymbols(dfs);
        str = str + nf.format(t.getSeconds());
        this.setStringValue(6, str);
    }

    @Override
    public void setStatus(TargetStatus status) {
        this.setCharValue(7, status.toChar());
    }

    @Override
    public void setReference(boolean isReference) {
        if (isReference) {
            this.setCharValue(8, 'R');
        }
    }
}

