/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.util;

public class SatelliteInfo {
    private String id;
    private int elevation;
    private int azimuth;
    private int noise;

    public SatelliteInfo(String id, int elevation, int azimuth, int noise) {
        this.id = id;
        this.elevation = elevation;
        this.azimuth = azimuth;
        this.noise = noise;
    }

    public int getAzimuth() {
        return this.azimuth;
    }

    public int getElevation() {
        return this.elevation;
    }

    public String getId() {
        return this.id;
    }

    public int getNoise() {
        return this.noise;
    }

    public void setAzimuth(int azimuth) {
        if (azimuth < 0 || azimuth > 360) {
            throw new IllegalArgumentException("Value out of bounds 0..360 deg");
        }
        this.azimuth = azimuth;
    }

    public void setElevation(int elevation) {
        if (elevation < 0 || elevation > 90) {
            throw new IllegalArgumentException("Value out of bounds 0..90 deg");
        }
        this.elevation = elevation;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setNoise(int noise) {
        if (noise < 0 || noise > 99) {
            throw new IllegalArgumentException("Value out of bounds 0..99 dB");
        }
        this.noise = noise;
    }

    public String toString() {
        return String.format("SatelliteInfo [id=%3s, elevation=%03d deg, azimuth=%03d deg, noise=%02d db]", this.getId(), this.getElevation(), this.getAzimuth(), this.getNoise());
    }
}

