/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.GregorianCalendar;

public class Time {
    private static final String TIME_PATTERN = "%02d:%02d:%02d%+03d:%02d";
    private int hour = 0;
    private int minutes = 0;
    private double seconds = 0.0;
    private int offsetHours = 0;
    private int offsetMinutes = 0;

    public Time() {
        GregorianCalendar c = new GregorianCalendar();
        this.hour = c.get(11);
        this.minutes = c.get(12);
        this.seconds = c.get(13);
    }

    public Time(String time) {
        this.setHour(Integer.parseInt(time.substring(0, 2)));
        this.setMinutes(Integer.parseInt(time.substring(2, 4)));
        this.setSeconds(Double.parseDouble(time.substring(4)));
    }

    public Time(int hour, int min, double sec) {
        this.setHour(hour);
        this.setMinutes(min);
        this.setSeconds(sec);
    }

    public Time(int hour, int min, double sec, int offsetHrs, int offsetMin) {
        this.setHour(hour);
        this.setMinutes(min);
        this.setSeconds(sec);
        this.setOffsetHours(offsetHrs);
        this.setOffsetMinutes(offsetMin);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Time) {
            Time d = (Time)obj;
            return d.getHour() == this.getHour() && d.getMinutes() == this.getMinutes() && d.getSeconds() == this.getSeconds() && d.getOffsetHours() == this.getOffsetHours() && d.getOffsetMinutes() == this.getOffsetMinutes();
        }
        return false;
    }

    public int getHour() {
        return this.hour;
    }

    public long getMilliseconds() {
        long m = Math.round(this.getSeconds() * 1000.0);
        m += (long)(this.getMinutes() * 60 * 1000);
        return m += (long)(this.getHour() * 3600 * 1000);
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getOffsetHours() {
        return this.offsetHours;
    }

    public int getOffsetMinutes() {
        return this.offsetMinutes;
    }

    public double getSeconds() {
        return this.seconds;
    }

    public int hashCode() {
        String s = String.format("%2d%2d%2f", this.hour, this.minutes, this.seconds);
        return s.hashCode();
    }

    public void setHour(int hour) {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("Valid hour value is between 0..23");
        }
        this.hour = hour;
    }

    public void setMinutes(int minutes) {
        if (minutes < 0 || minutes > 59) {
            throw new IllegalArgumentException("Valid minutes value is between 0..59");
        }
        this.minutes = minutes;
    }

    public void setOffsetHours(int hours) {
        if (hours < -13 || hours > 13) {
            throw new IllegalArgumentException("Offset out of bounds [-13..13]");
        }
        this.offsetHours = hours;
    }

    public void setOffsetMinutes(int minutes) {
        if (minutes < -59 || minutes > 59) {
            throw new IllegalArgumentException("Offset out of bounds [-59..59]");
        }
        this.offsetMinutes = minutes;
    }

    public void setSeconds(double seconds) {
        if (seconds < 0.0 || seconds >= 60.0) {
            throw new IllegalArgumentException("Invalid value for second (0 < seconds < 60)");
        }
        this.seconds = seconds;
    }

    public void setTime(Date d) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(d);
        double seconds = (double)cal.get(13) + (double)cal.get(14) / 1000.0;
        this.setHour(cal.get(11));
        this.setMinutes(cal.get(12));
        this.setSeconds(seconds);
    }

    public Date toDate(Date d) {
        double seconds = this.getSeconds();
        int fullSeconds = (int)Math.floor(seconds);
        int milliseconds = (int)Math.round((seconds - (double)fullSeconds) * 1000.0);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(d);
        cal.set(11, this.getHour());
        cal.set(12, this.getMinutes());
        cal.set(13, fullSeconds);
        cal.set(14, milliseconds);
        return cal.getTime();
    }

    public String toString() {
        String str = String.format("%02d%02d", this.getHour(), this.getMinutes());
        DecimalFormat nf = new DecimalFormat("00.000");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        nf.setDecimalFormatSymbols(dfs);
        return str.concat(nf.format(this.getSeconds()));
    }

    public String toISO8601() {
        int hr = this.getHour();
        int min = this.getMinutes();
        int sec = (int)Math.floor(this.getSeconds());
        int tzHr = this.getOffsetHours();
        int tzMin = this.getOffsetMinutes();
        return String.format(TIME_PATTERN, hr, min, sec, tzHr, tzMin);
    }
}

