/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.marineapi.nmea.event.SentenceEvent;
import net.sf.marineapi.nmea.event.SentenceListener;
import net.sf.marineapi.nmea.io.SentenceReader;
import net.sf.marineapi.nmea.sentence.Sentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.provider.event.ProviderEvent;
import net.sf.marineapi.provider.event.ProviderListener;

public abstract class AbstractProvider<T extends ProviderEvent>
implements SentenceListener {
    public static int DEFAULT_TIMEOUT = 1000;
    private SentenceReader reader;
    private List<SentenceEvent> events = new ArrayList<SentenceEvent>();
    private List<ProviderListener<T>> listeners = new ArrayList<ProviderListener<T>>();
    private int timeout = DEFAULT_TIMEOUT;

    public AbstractProvider(SentenceReader reader, String ... ids) {
        this.reader = reader;
        for (String id : ids) {
            reader.addSentenceListener((SentenceListener)this, id);
        }
    }

    public AbstractProvider(SentenceReader reader, SentenceId ... ids) {
        this.reader = reader;
        for (SentenceId id : ids) {
            reader.addSentenceListener((SentenceListener)this, id);
        }
    }

    public void addListener(ProviderListener<T> listener) {
        this.listeners.add(listener);
    }

    protected abstract T createProviderEvent();

    private void fireProviderEvent(T event) {
        for (ProviderListener<T> listener : this.listeners) {
            listener.providerUpdate(event);
        }
    }

    protected final List<Sentence> getSentences() {
        ArrayList<Sentence> s = new ArrayList<Sentence>();
        for (SentenceEvent e : this.events) {
            s.add(e.getSentence());
        }
        return s;
    }

    protected final boolean hasAll(String ... id) {
        for (String s : id) {
            if (this.hasOne(s)) continue;
            return false;
        }
        return true;
    }

    protected final boolean hasOne(String ... id) {
        List<String> ids = Arrays.asList(id);
        for (Sentence s : this.getSentences()) {
            if (!ids.contains(s.getSentenceId())) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean isReady();

    protected abstract boolean isValid();

    @Override
    public void readingPaused() {
    }

    @Override
    public void readingStarted() {
        this.reset();
    }

    @Override
    public void readingStopped() {
        this.reset();
        this.reader.removeSentenceListener(this);
    }

    public void removeListener(ProviderListener<T> listener) {
        this.listeners.remove(listener);
    }

    private void reset() {
        this.events.clear();
    }

    private void expunge() {
        long now = System.currentTimeMillis();
        ArrayList<SentenceEvent> expired = new ArrayList<SentenceEvent>();
        for (SentenceEvent e : this.events) {
            if (now - e.getTimeStamp() <= (long)this.timeout) continue;
            expired.add(e);
        }
        this.events.removeAll(expired);
    }

    @Override
    public void sentenceRead(SentenceEvent event) {
        this.events.add(event);
        if (this.isReady()) {
            if (this.validate()) {
                T pEvent = this.createProviderEvent();
                this.fireProviderEvent(pEvent);
            }
            this.reset();
        } else {
            this.expunge();
        }
    }

    public void setTimeout(int millis) {
        if (millis < 1) {
            throw new IllegalArgumentException("Timeout value must be > 0");
        }
        this.timeout = millis;
    }

    private boolean validate() {
        long now = System.currentTimeMillis();
        for (SentenceEvent se : this.events) {
            long age = now - se.getTimeStamp();
            if (age <= (long)this.timeout) continue;
            return false;
        }
        return this.isValid();
    }
}

