/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ublox.parser;

import net.sf.marineapi.nmea.parser.PositionParser;
import net.sf.marineapi.nmea.sentence.UBXSentence;
import net.sf.marineapi.nmea.util.Position;
import net.sf.marineapi.nmea.util.Time;
import net.sf.marineapi.ublox.message.UBXMessage00;
import net.sf.marineapi.ublox.parser.UBXMessageParser;
import net.sf.marineapi.ublox.util.UbloxNavigationStatus;

class UBXMessage00Parser
extends UBXMessageParser
implements UBXMessage00 {
    private static final int UTC_TIME = 1;
    private static final int LATITUDE = 2;
    private static final int LAT_HEMISPHERE = 3;
    private static final int LONGITUDE = 4;
    private static final int LON_HEMISPHERE = 5;
    private static final int ALTITUDE = 6;
    private static final int NAVIGATION_STATUS = 7;
    private static final int HORIZONTAL_ACCURACY_ESTIMATE = 8;
    private static final int VERTICAL_ACCURACY_ESTIMATE = 9;
    private static final int SPEED_OVER_GROUND = 10;
    private static final int COURSE_OVER_GROUND = 11;
    private static final int VERTICA_VELOCITY = 12;
    private static final int AGE_OF_DIFFERENTIAL_CORRECTIONS = 13;
    private static final int HDOP = 14;
    private static final int VDOP = 15;
    private static final int TDOP = 16;
    private static final int NUMBER_OF_SATELLITES_USED = 17;

    public UBXMessage00Parser(UBXSentence sentence) {
        super(sentence);
    }

    @Override
    public Time getUtcTime() {
        String str = this.getStringValue(1);
        return new Time(str);
    }

    @Override
    public Position getPosition() {
        String latitudeField = this.sentence.getUBXFieldStringValue(2);
        char latitudeHemisphereIndicatorField = this.sentence.getUBXFieldCharValue(3);
        String longitudeField = this.sentence.getUBXFieldStringValue(4);
        char longitudeHemisphereIndicatorField = this.sentence.getUBXFieldCharValue(5);
        Position position = PositionParser.parsePosition(latitudeField, latitudeHemisphereIndicatorField, longitudeField, longitudeHemisphereIndicatorField);
        double altitude = this.sentence.getUBXFieldDoubleValue(6);
        position.setAltitude(altitude);
        return position;
    }

    @Override
    public UbloxNavigationStatus getNavigationStatus() {
        return UbloxNavigationStatus.fromNavigationStatusCode(this.sentence.getUBXFieldStringValue(7));
    }

    @Override
    public double getHorizontalAccuracyEstimate() {
        return this.sentence.getUBXFieldDoubleValue(8);
    }

    @Override
    public double getVerticaAccuracyEstimate() {
        return this.sentence.getUBXFieldDoubleValue(9);
    }

    @Override
    public double getSpeedOverGround() {
        return this.sentence.getUBXFieldDoubleValue(10);
    }

    @Override
    public double getCourseOverGround() {
        return this.sentence.getUBXFieldDoubleValue(11);
    }

    @Override
    public double getVerticaVelocity() {
        return this.sentence.getUBXFieldDoubleValue(12);
    }

    @Override
    public int getAgeOfDifferentialCorrections() {
        return this.sentence.getUBXFieldIntValue(13);
    }

    @Override
    public double getHDOP() {
        return this.sentence.getUBXFieldDoubleValue(14);
    }

    @Override
    public double getVDOP() {
        return this.sentence.getUBXFieldDoubleValue(15);
    }

    @Override
    public double getTDOP() {
        return this.sentence.getUBXFieldDoubleValue(16);
    }

    @Override
    public int getNumberOfSatellitesUsed() {
        return this.sentence.getUBXFieldIntValue(17);
    }
}

